/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.jni.JNIGlobalHandles;
import com.oracle.svm.jni.JNIThreadLocalHandles;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIObjectRefType;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.SignedWord;

public final class JNIObjectHandles {
    public static <T extends SignedWord> T nullHandle() {
        return (T)ThreadLocalHandles.nullHandle();
    }

    public static <T> T getObject(JNIObjectHandle handle) {
        if (handle.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            return null;
        }
        if (ThreadLocalHandles.isInRange(handle)) {
            return (T)JNIThreadLocalHandles.get().getObject(handle);
        }
        if (JNIGlobalHandles.singleton().isInRange(handle)) {
            return JNIGlobalHandles.singleton().get(handle);
        }
        throw new RuntimeException("Invalid object handle");
    }

    public static JNIObjectRefType getHandleType(JNIObjectHandle handle) {
        if (ThreadLocalHandles.isInRange(handle)) {
            return JNIObjectRefType.Local;
        }
        if (JNIGlobalHandles.singleton().isInRange(handle)) {
            if (JNIGlobalHandles.singleton().isWeak(handle)) {
                return JNIObjectRefType.WeakGlobal;
            }
            return JNIObjectRefType.Global;
        }
        return JNIObjectRefType.Invalid;
    }
}

