/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class FeatureHandler {
    private final ArrayList<Feature> featureInstances = new ArrayList();
    private final HashSet<Class<?>> registeredFeatures = new HashSet();

    public void forEachFeature(Consumer<Feature> consumer) {
        for (Feature feature : this.featureInstances) {
            consumer.accept(feature);
        }
    }

    public void forEachGraalFeature(Consumer<GraalFeature> consumer) {
        for (Feature feature : this.featureInstances) {
            if (!(feature instanceof GraalFeature)) continue;
            consumer.accept((GraalFeature)feature);
        }
    }

    public void registerFeatures(ImageClassLoader loader, DebugContext debug) {
        FeatureImpl.IsInConfigurationAccessImpl access = new FeatureImpl.IsInConfigurationAccessImpl(this, loader, debug);
        for (Class<?> automaticFeature : loader.findAnnotatedClasses(AutomaticFeature.class)) {
            this.registerFeature(automaticFeature, access);
        }
        for (String featureName : OptionUtils.flatten(",", Options.Features.getValue())) {
            try {
                this.registerFeature(Class.forName(featureName, true, loader.getClassLoader()), access);
            }
            catch (ClassNotFoundException e) {
                throw UserError.abort("feature " + featureName + " class not found on the classpath. Ensure that the name is correct and that the class is on the classpath.");
            }
        }
    }

    private void registerFeature(Class<?> featureClass, FeatureImpl.IsInConfigurationAccessImpl access) {
        Feature feature;
        if (!Feature.class.isAssignableFrom(featureClass)) {
            throw UserError.abort("Class does not implement " + Feature.class.getName() + ": " + featureClass.getName());
        }
        if (this.registeredFeatures.contains(featureClass)) {
            return;
        }
        this.registeredFeatures.add(featureClass);
        try {
            Constructor<?> constructor = featureClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            feature = (Feature)constructor.newInstance(new Object[0]);
            if (!feature.isInConfiguration((Feature.IsInConfigurationAccess)access)) {
                return;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        ImageSingletons.add(feature.getClass(), (Object)feature);
        for (Class requiredFeatureClass : feature.getRequiredFeatures()) {
            this.registerFeature(requiredFeatureClass, access);
        }
        this.featureInstances.add(feature);
    }

    public static class Options {
        @APIOption(name="features")
        @Option(help={"A comma-separated list of fully qualified Feature implementation classes"})
        public static final HostedOptionKey<String[]> Features = new HostedOptionKey<Object>(null);
    }
}

