/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.windows.Target_java_io_FileDescriptor;
import com.oracle.svm.core.windows.Target_java_io_FileInputStream;
import com.oracle.svm.core.windows.Target_java_io_FileOutputStream;
import com.oracle.svm.core.windows.Target_java_io_WinNTFileSystem;
import com.oracle.svm.core.windows.Target_java_util_zip_Deflater;
import com.oracle.svm.core.windows.Target_java_util_zip_Inflater;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.WINDOWS.class})
public final class WindowsJavaIOSubstitutions {
    private WindowsJavaIOSubstitutions() {
    }

    public static boolean initIDs() {
        try {
            System.loadLibrary("java");
            Target_java_io_FileDescriptor.initIDs();
            Target_java_io_FileInputStream.initIDs();
            Target_java_io_FileOutputStream.initIDs();
            Target_java_io_WinNTFileSystem.initIDs();
            Target_java_io_FileDescriptor.in = Target_java_io_FileDescriptor.standardStream(0);
            Target_java_io_FileDescriptor.out = Target_java_io_FileDescriptor.standardStream(1);
            Target_java_io_FileDescriptor.err = Target_java_io_FileDescriptor.standardStream(2);
            System.setIn(new BufferedInputStream(new FileInputStream(FileDescriptor.in)));
            System.setOut(new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true));
            System.setErr(new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true));
            System.loadLibrary("zip");
            Target_java_util_zip_Inflater.initIDs();
            Target_java_util_zip_Deflater.initIDs();
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.log().string("System.loadLibrary failed, " + e).newline();
            return false;
        }
    }
}

