/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ProcessProperties;

public class FallbackExecutor {
    private static final Path buildTimeJavaHome = Paths.get(System.getProperty("java.home"), new String[0]);

    public static void main(String[] args) {
        ArrayList<String> command = new ArrayList<String>();
        Path javaExecutable = FallbackExecutor.getJavaExecutable().toAbsolutePath().normalize();
        command.add(javaExecutable.toString());
        String[] properties = Options.FallbackExecutorSystemProperty.getValue();
        if (properties != null) {
            for (String p : properties) {
                command.add(p);
            }
        }
        command.add("-Dorg.graalvm.nativeimage.kind=fallback-executable");
        Path fallbackImageDir = Paths.get(ProcessProperties.getExecutableName(), new String[0]).getParent();
        if (fallbackImageDir == null) {
            VMError.shouldNotReachHere();
        }
        String pathPrefix = fallbackImageDir.toAbsolutePath().normalize().toString();
        String relativeClasspath = Options.FallbackExecutorClasspath.getValue();
        CharSequence[] split = SubstrateUtil.split(relativeClasspath, File.pathSeparator);
        for (int i = 0; i < split.length; ++i) {
            split[i] = pathPrefix + File.separator + (String)split[i];
        }
        String absoluteClasspath = String.join((CharSequence)File.pathSeparator, split);
        command.add("-cp");
        command.add(absoluteClasspath);
        command.add(Options.FallbackExecutorMainClass.getValue());
        command.addAll(Arrays.asList(args));
        if (System.getenv("FALLBACK_EXECUTOR_VERBOSE") != null) {
            System.out.println("Exec: " + String.join((CharSequence)" ", command));
        }
        ProcessProperties.exec((Path)javaExecutable, (String[])command.toArray(new String[0]));
    }

    private static Path getJavaExecutable() {
        Path binJava = Paths.get("bin", OS.getCurrent() == OS.WINDOWS ? "java.exe" : "java");
        Path javaCandidate = buildTimeJavaHome.resolve(binJava);
        if (Files.isExecutable(javaCandidate)) {
            return javaCandidate;
        }
        javaCandidate = Paths.get(".", new String[0]).resolve(binJava);
        if (Files.isExecutable(javaCandidate)) {
            return javaCandidate;
        }
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            FallbackExecutor.showError("No " + binJava + " and no environment variable JAVA_HOME");
        }
        try {
            javaCandidate = Paths.get(javaHome, new String[0]).resolve(binJava);
            if (Files.isExecutable(javaCandidate)) {
                return javaCandidate;
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        FallbackExecutor.showError("No " + binJava + " and invalid JAVA_HOME=" + javaHome);
        return null;
    }

    private static void showError(String s) {
        System.err.println("Error: " + s);
        System.exit(1);
    }

    public static class Options {
        @Option(help={"Internal option used to specify system properties for FallbackExecutor."})
        public static final HostedOptionKey<String[]> FallbackExecutorSystemProperty = new HostedOptionKey<Object>(null);
        @Option(help={"Internal option used to specify MainClass for FallbackExecutor."})
        public static final HostedOptionKey<String> FallbackExecutorMainClass = new HostedOptionKey<Object>(null);
        @Option(help={"Internal option used to specify Classpath for FallbackExecutor."})
        public static final HostedOptionKey<String> FallbackExecutorClasspath = new HostedOptionKey<Object>(null);
    }
}

