/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.Target_sun_util_locale_provider_LocaleServiceProviderPool;
import com.oracle.svm.core.util.VMError;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.spi.LocaleServiceProvider;
import sun.util.locale.provider.LocaleProviderAdapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class Util_sun_util_locale_provider_LocaleProviderAdapter {
    static final Map<Class<? extends LocaleServiceProvider>, LocaleProviderAdapter> cachedAdaptersByClass;
    static final Map<LocaleProviderAdapter.Type, LocaleProviderAdapter> cachedAdaptersByType;

    Util_sun_util_locale_provider_LocaleProviderAdapter() {
    }

    static LocaleProviderAdapter getByClass(Class<? extends LocaleServiceProvider> klass) {
        return cachedAdaptersByClass.get(klass);
    }

    static LocaleProviderAdapter getByType(LocaleProviderAdapter.Type type) {
        return cachedAdaptersByType.get((Object)type);
    }

    static {
        LocaleProviderAdapter adapter;
        cachedAdaptersByClass = new HashMap<Class<? extends LocaleServiceProvider>, LocaleProviderAdapter>();
        try {
            Class<LocaleServiceProvider>[] spiClasses;
            for (Class<LocaleServiceProvider> clazz : spiClasses = Target_sun_util_locale_provider_LocaleServiceProviderPool.spiClasses()) {
                adapter = LocaleProviderAdapter.getAdapter(clazz, Locale.getDefault());
                cachedAdaptersByClass.put(clazz, adapter);
            }
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        cachedAdaptersByType = new HashMap<LocaleProviderAdapter.Type, LocaleProviderAdapter>();
        try {
            LocaleProviderAdapter.Type[] acceptableTypes;
            for (LocaleProviderAdapter.Type type : acceptableTypes = new LocaleProviderAdapter.Type[]{LocaleProviderAdapter.Type.JRE, LocaleProviderAdapter.Type.CLDR}) {
                adapter = LocaleProviderAdapter.forType(type);
                cachedAdaptersByType.put(type, adapter);
            }
        }
        catch (Throwable throwable) {
            throw VMError.shouldNotReachHere(throwable);
        }
    }
}

