/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.word.WordBase;

public abstract class ObjectScanner {
    protected final BigBang bb;
    protected final Map<Object, Boolean> scannedObjects;
    protected final Deque<WorklistEntry> worklist;

    public ObjectScanner(BigBang bigbang) {
        this.bb = bigbang;
        this.scannedObjects = new IdentityHashMap<Object, Boolean>();
        this.worklist = new ArrayDeque<WorklistEntry>();
    }

    public void scanBootImageHeapRoots() {
        this.scanBootImageHeapRoots((f1, f2) -> 0, (m1, m2) -> 0);
    }

    public void scanBootImageHeapRoots(Comparator<AnalysisField> fieldComparator, Comparator<AnalysisMethod> methodComparator) {
        this.bb.getUniverse().getFields().stream().filter(field -> Modifier.isStatic(field.getModifiers()) && field.getJavaKind() == JavaKind.Object && field.isAccessed()).sorted(fieldComparator).forEach(field -> this.scanField((AnalysisField)field, null, field));
        this.bb.getUniverse().getMethods().stream().filter(method -> method.getTypeFlow().getGraph() != null).sorted(methodComparator).forEach(this::scanMethod);
        this.finish();
    }

    public abstract void forRelocatedPointerFieldValue(JavaConstant var1, AnalysisField var2, JavaConstant var3);

    public abstract void forNullFieldValue(JavaConstant var1, AnalysisField var2);

    public abstract void forNonNullFieldValue(JavaConstant var1, AnalysisField var2, JavaConstant var3);

    protected final void scanField(AnalysisField field, JavaConstant receiver, Object reason) {
        try {
            JavaConstant fieldValue = this.bb.getConstantReflectionProvider().readFieldValue((ResolvedJavaField)field, receiver);
            if (fieldValue == null) {
                StringBuilder backtrace = new StringBuilder();
                this.buildObjectBacktrace(reason, backtrace);
                throw AnalysisError.shouldNotReachHere("Could not find field " + field.format("%H.%n") + (receiver == null ? "" : " on " + this.bb.getSnippetReflectionProvider().asObject(Object.class, receiver).getClass()) + System.lineSeparator() + backtrace.toString());
            }
            if (fieldValue.getJavaKind() == JavaKind.Object && this.bb.getHostVM().isRelocatedPointer(this.bb.getSnippetReflectionProvider().asObject(Object.class, fieldValue))) {
                this.forRelocatedPointerFieldValue(receiver, field, fieldValue);
            } else if (fieldValue.isNull()) {
                this.forNullFieldValue(receiver, field);
            } else if (fieldValue.getJavaKind() == JavaKind.Object) {
                if (receiver == null) {
                    this.registerRoot(fieldValue, field);
                } else {
                    this.propagateRoot(receiver, fieldValue);
                }
                this.scanConstant(fieldValue, reason);
                this.forNonNullFieldValue(receiver, field, fieldValue);
            }
        }
        catch (UnsupportedFeatureException ex) {
            this.unsupportedFeature(field.format("%H.%n"), ex.getMessage(), reason);
        }
    }

    private void registerRoot(JavaConstant fieldValue, AnalysisField field) {
        this.bb.addRoot(fieldValue, field);
    }

    private void propagateRoot(JavaConstant receiver, JavaConstant value) {
        Object receiverRoot = this.bb.getRoot(receiver);
        if (receiverRoot != null) {
            this.bb.addRoot(value, receiverRoot);
        }
    }

    public abstract void forNullArrayElement(JavaConstant var1, AnalysisType var2, int var3);

    public abstract void forNonNullArrayElement(JavaConstant var1, AnalysisType var2, JavaConstant var3, AnalysisType var4, int var5);

    protected final void scanArray(JavaConstant array, Object reason) {
        Object valueObj = this.bb.getSnippetReflectionProvider().asObject(Object.class, array);
        ResolvedJavaType arrayType = this.bb.getMetaAccess().lookupJavaType((Class)valueObj.getClass());
        assert (valueObj instanceof Object[]);
        try {
            Object[] arrayObject = (Object[])valueObj;
            for (int idx = 0; idx < arrayObject.length; ++idx) {
                Object e = arrayObject[idx];
                if (e == null) {
                    this.forNullArrayElement(array, (AnalysisType)arrayType, idx);
                    continue;
                }
                Object element = this.bb.getUniverse().replaceObject(e);
                JavaConstant elementConstant = this.bb.getSnippetReflectionProvider().forObject(element);
                ResolvedJavaType elementType = this.bb.getMetaAccess().lookupJavaType((Class)element.getClass());
                this.propagateRoot(array, elementConstant);
                this.scanConstant(elementConstant, reason);
                this.forNonNullArrayElement(array, (AnalysisType)arrayType, elementConstant, (AnalysisType)elementType, idx);
            }
        }
        catch (UnsupportedFeatureException ex) {
            this.unsupportedFeature(arrayType.toJavaName(true), ex.getMessage(), reason);
        }
    }

    protected abstract void forScannedConstant(JavaConstant var1, Object var2);

    public final void scanConstant(JavaConstant value, Object reason) {
        Object valueObj = this.bb.getSnippetReflectionProvider().asObject(Object.class, value);
        if (valueObj == null || this.scannedObjects.containsKey(valueObj) || valueObj instanceof WordBase) {
            return;
        }
        this.scannedObjects.put(valueObj, Boolean.TRUE);
        this.forScannedConstant(value, reason);
        this.worklist.push(new WorklistEntry(value, reason));
    }

    private void unsupportedFeature(String key, String message, Object entry) {
        StringBuilder objectBacktrace = new StringBuilder();
        AnalysisMethod method = this.buildObjectBacktrace(entry, objectBacktrace);
        this.bb.getUnsupportedFeatures().addMessage(key, method, message, objectBacktrace.toString());
    }

    private AnalysisMethod buildObjectBacktrace(Object entry, StringBuilder objectBacktrace) {
        Object cur = entry;
        AnalysisMethod method = null;
        while (cur instanceof WorklistEntry) {
            WorklistEntry curEntry = (WorklistEntry)cur;
            objectBacktrace.append("\tobject ").append(this.bb.getMetaAccess().lookupJavaType(curEntry.constant).toJavaName(true)).append(System.lineSeparator());
            cur = curEntry.reason;
        }
        if (cur instanceof ResolvedJavaField) {
            objectBacktrace.append("\tfield ").append(((ResolvedJavaField)cur).format("%H.%n"));
        } else if (cur instanceof ResolvedJavaMethod) {
            objectBacktrace.append("\tmethod ").append(((ResolvedJavaMethod)cur).format("%H.%n(%p)"));
            method = (AnalysisMethod)cur;
        } else {
            objectBacktrace.append("\t[unknown] ").append(cur.toString());
        }
        return method;
    }

    private void doScan(WorklistEntry entry) {
        Object valueObj = this.bb.getSnippetReflectionProvider().asObject(Object.class, entry.constant);
        assert (this.checkCorrectClassloaders(entry, valueObj)) : "Invalid classloader " + valueObj.getClass().getClassLoader() + " for " + valueObj + ".\nThis error happens when objects from previous image compilations are reached in the current compilation. To prevent this issue reset all static state from the bootclasspath and application classpath that points to the application objects. For reference, see com.oracle.svm.truffle.TruffleFeature.cleanup().";
        ResolvedJavaType type = this.bb.getMetaAccess().lookupJavaType((Class)valueObj.getClass());
        if (type.isInstanceClass()) {
            for (AnalysisField field : type.getInstanceFields(true)) {
                if (field.getJavaKind() != JavaKind.Object || !field.isAccessed()) continue;
                assert (!Modifier.isStatic(field.getModifiers()));
                this.scanField(field, entry.constant, entry);
            }
        } else if (type.isArray() && this.bb.getProviders().getWordTypes().asKind((JavaType)type.getComponentType()) == JavaKind.Object) {
            this.scanArray(entry.constant, entry);
        }
    }

    private void scanMethod(AnalysisMethod method) {
        try {
            StreamSupport.stream(method.getTypeFlow().getGraph().getNodes().spliterator(), false).filter(n -> n instanceof ConstantNode).forEach(n -> {
                ConstantNode cn = (ConstantNode)n;
                JavaConstant c = (JavaConstant)cn.getValue();
                if (c.getJavaKind() == JavaKind.Object) {
                    this.scanConstant(c, method);
                }
            });
        }
        catch (UnsupportedFeatureException ex) {
            this.bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, ex.getMessage(), null, ex);
        }
    }

    private boolean checkCorrectClassloaders(WorklistEntry entry, Object valueObj) {
        boolean result = this.bb.isValidClassLoader(valueObj);
        if (!result) {
            System.err.println("detected an object that originates from previous compilations: " + valueObj.toString());
            Object reason = entry.getReason();
            while (reason instanceof WorklistEntry) {
                Object value = this.bb.getSnippetReflectionProvider().asObject(Object.class, ((WorklistEntry)reason).constant);
                System.err.println("  referenced from " + value.toString());
                reason = ((WorklistEntry)reason).getReason();
            }
            System.err.println("  referenced from " + reason);
        }
        return result;
    }

    protected void finish() {
        while (!this.worklist.isEmpty()) {
            this.doScan(this.worklist.pop());
        }
    }

    static class WorklistEntry {
        private final JavaConstant constant;
        private final Object reason;

        WorklistEntry(JavaConstant constant, Object reason) {
            this.constant = constant;
            this.reason = reason;
        }

        public JavaConstant getConstant() {
            return this.constant;
        }

        public Object getReason() {
            return this.reason;
        }
    }
}

