/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.charset.Charset;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

final class NIORefusePacket
extends NIOPacket {
    int userReason;
    int systemReason;
    String refuseData;

    NIORefusePacket(NIOHeader nIOHeader, SessionAtts sessionAtts) throws IOException {
        super(nIOHeader, sessionAtts);
    }

    @Override
    void readPayloadBuffer() throws IOException, NetException {
        this.userReason = this.session.payloadBufferForRead.get();
        this.systemReason = this.session.payloadBufferForRead.get();
        short s2 = this.session.payloadBufferForRead.getShort();
        if (s2 > 0) {
            byte[] byArray = null;
            if (this.session.payloadBufferForRead.limit() > this.session.payloadBufferForRead.position()) {
                byArray = new byte[s2];
                this.session.payloadBufferForRead.get(byArray);
            } else {
                byArray = this.session.dataChannel.readPayloadDataFromSocketChannel(s2);
            }
            this.refuseData = new String(byArray, Charset.forName("US-ASCII"));
        } else {
            this.refuseData = "";
        }
    }
}

