/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import oracle.ons.CallBackMode;
import oracle.ons.Closable;
import oracle.ons.ConfigurationException;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.ONSNodeList;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.impl.RpcServerImpl;

public class ONS
implements Closable {
    public static final String ONS_PERM_STRING = "ONSUser";
    public static final int ONS_ORACLE_HOME = 1;
    public static final int ONS_CONFIG_FILE = 2;
    public static final int ONS_ORACLE_INSTANCE = 3;
    public static final int ONS_PROTOCOL_VERSION = 6;
    public final ONSConfiguration config;
    private boolean adoptObjects = true;
    NotificationNetwork network;
    private List<WeakReference<Closable>> children = new ArrayList<WeakReference<Closable>>(2);
    private StreamHandler errorStreamHandler = null;
    private StreamHandler outStreamHandler = null;
    private static volatile ONS someONS = null;
    public PrintStream errstream;
    private PrintStream outstream;
    @Deprecated
    public boolean debug;

    public void setAdoptObjects(boolean bl) {
        this.adoptObjects = bl;
    }

    protected synchronized void addChildObject(Closable closable) {
        if (this.adoptObjects) {
            ONS.debug("ONS " + this + " add child " + closable);
            this.children.add(new WeakReference<Closable>(closable));
        }
    }

    public ONSConfiguration getConfiguration() {
        return this.config;
    }

    public synchronized NotificationNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        return this.config.getNetwork();
    }

    private void init() throws ONSException {
        this.network = this.config.getNetwork();
        ONS.debug("ONS " + this + " network: " + this.network + " init");
        try {
            this.network.demand();
            this.network.waitUntilOnline(this.config.getSocketTimeout(), true);
            ONS.debug("ONS " + this + " online");
        }
        catch (InterruptedException interruptedException) {
            this.network.release();
            ONS.debug("ONS " + this + " network wait failed");
            Thread.currentThread().interrupt();
        }
    }

    public ONS(int n, String string) throws ONSException {
        ONS.debug("ONS(" + n + "," + string + ") ONS object: " + this);
        switch (n) {
            case 2: {
                this.config = ONSConfiguration.getLocalConfigFromFile(null, new File(string), null);
                break;
            }
            case 1: {
                this.config = ONSConfiguration.getLocalConfigFromFile(string, null, null);
                break;
            }
            default: {
                throw new ConfigurationException("Unknown parameter for ONS initialization");
            }
        }
        ONS.debug("ONS " + this + " config: " + this.config);
        this.init();
    }

    public ONS(ONSConfiguration oNSConfiguration) {
        ONS.debug("ONS(" + oNSConfiguration + ") [config object] ONS object: " + this);
        this.config = oNSConfiguration;
        someONS = this;
    }

    public ONS() {
        ONS.debug("ONS() ONS object: " + this);
        this.config = ONSConfiguration.initDefaultConfig();
        ONS.debug("ONS " + this + " config: " + this.config);
        someONS = this;
    }

    public ONS(String string) throws ONSException {
        ONS.debug("ONS(" + string + ") ONS object: " + this);
        this.config = ONSConfiguration.getRemoteConfigFromString(string);
        ONS.debug("ONS " + this + " config: " + this.config);
        this.init();
        someONS = this;
    }

    public synchronized void shutdown() {
        ONS.debug("ONS " + this + " begin shutdown");
        if (someONS == this) {
            someONS = null;
        }
        for (WeakReference<Closable> weakReference : this.children) {
            Closable closable = (Closable)weakReference.get();
            if (closable == null) continue;
            ONS.debug("ONS " + this + " close child " + closable);
            closable.close();
        }
        if (this.network != null) {
            this.network.release();
            this.network = null;
        }
        ONS.debug("ONS " + this + " end shutdown");
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Deprecated
    public static ONS getRunningONS() {
        return someONS;
    }

    @Deprecated
    public void shutdown(long l) {
        this.shutdown();
    }

    public Subscriber createNewSubscriber(String string, String string2) {
        return new Subscriber(this, string, string2, this.config.getSocketTimeout());
    }

    public Subscriber createNewSubscriber(String string, String string2, long l) {
        return new Subscriber(this, string, string2, l);
    }

    public Publisher createNewPublisher(String string) {
        return new Publisher(this.config, string);
    }

    public int readLocalPort(String string) throws ONSException {
        return this.config.getLocalPort();
    }

    public int readRemotePort(String string) throws ONSException {
        return this.config.getRemotePort();
    }

    public static String readFormFactor(String string) throws ONSException {
        try {
            return ONSConfiguration.getFormFactor(string);
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Error reading form factor file");
        }
    }

    public Set<ONSNodeList> getONSNodeLists() {
        NotificationNetwork notificationNetwork = this.config.getNetwork();
        HashSet<ONSNodeList> hashSet = new HashSet<ONSNodeList>();
        for (ONSConfiguration.NodeList nodeList : notificationNetwork.nodeLists) {
            hashSet.add(new ONSNodeList(nodeList));
        }
        return hashSet;
    }

    @Deprecated
    public Object getNodeLists() {
        return null;
    }

    @Deprecated
    public Object getConnections() {
        return null;
    }

    public static void error(String string) {
        NotificationManager.getNotificationManager().logger.fine(string);
    }

    public static void debug(String string) {
        NotificationManager.getNotificationManager().logger.info(string);
    }

    public static void debugRaw(String string) {
        NotificationManager.getNotificationManager().logger.info(string);
    }

    @Deprecated
    public void printLists() {
    }

    public static Logger getLogger() {
        return NotificationManager.getNotificationManager().logger;
    }

    public RpcServer createRpcServer(String string, String string2, Map<String, String> map, CallBackMode callBackMode) {
        return new RpcServerImpl(this, string, string2, map, callBackMode);
    }

    public RpcServer createRpcServer(String string, String string2, Map<String, String> map, CallBackMode callBackMode, boolean bl) {
        return new RpcServerImpl(this, string, string2, map, callBackMode, bl);
    }

    @Deprecated
    public void setLogStream(PrintStream printStream, PrintStream printStream2) {
    }

    static ONS getONS() throws ConfigurationException {
        return new ONS(ONSConfiguration.initDefaultConfig());
    }

    static String exceptionMsg(Exception exception) {
        String string = exception.getLocalizedMessage();
        if (string == null && (string = exception.getMessage()) == null) {
            string = exception.toString();
        }
        return string;
    }
}

