/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.concurrent.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Experimental;

@Experimental
public class Caching
implements Option {
    private boolean enabled;
    private OptionsByType optionsByType;

    private Caching(boolean enabled, Option ... options) {
        this.enabled = enabled;
        this.optionsByType = options == null || options.length == 0 ? OptionsByType.empty() : OptionsByType.of((Option[])options);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public OptionsByType getOptionsByType() {
        return this.optionsByType;
    }

    public static Caching enabled(Option ... options) {
        return new Caching(true, options);
    }

    @OptionsByType.Default
    public static Caching disabled() {
        return new Caching(false, new Option[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Caching)) {
            return false;
        }
        Caching caching = (Caching)o;
        if (this.enabled != caching.enabled) {
            return false;
        }
        return this.optionsByType != null ? this.optionsByType.equals((Object)caching.optionsByType) : caching.optionsByType == null;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.optionsByType != null ? this.optionsByType.hashCode() : 0);
        return result;
    }
}

