/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.service.documenteditor.callback;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.model.documenteditor.Callback;
import com.onlyoffice.service.documenteditor.callback.CallbackService;
import org.json.JSONObject;

public class DefaultCallbackService
implements CallbackService {
    private JwtManager jwtManager;
    private SettingsManager settingsManager;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Callback verifyCallback(Callback callback, String authorizationHeader) throws JsonProcessingException {
        if (this.settingsManager.isSecurityEnabled().booleanValue()) {
            String token = callback.getToken();
            String payload = null;
            Boolean fromHeader = false;
            if ((token == null || token.isEmpty()) && authorizationHeader != null && !authorizationHeader.isEmpty() && authorizationHeader.startsWith(this.settingsManager.getSecurityPrefix())) {
                token = authorizationHeader.substring(this.settingsManager.getSecurityPrefix().length());
                fromHeader = true;
            }
            if (token == null || token == "") {
                throw new SecurityException("Not found authorization token");
            }
            payload = this.jwtManager.verify(token);
            JSONObject callbackFromToken = new JSONObject(payload);
            if (fromHeader.booleanValue()) {
                callbackFromToken = callbackFromToken.getJSONObject("payload");
            }
            return (Callback)this.objectMapper.readValue(callbackFromToken.toString(), Callback.class);
        }
        return callback;
    }

    @Override
    public void processCallback(Callback callback, String fileId) throws Exception {
        switch (callback.getStatus()) {
            case EDITING: {
                this.handlerEditing(callback, fileId);
                break;
            }
            case SAVE: {
                this.handlerSave(callback, fileId);
                break;
            }
            case SAVE_CORRUPTED: {
                this.handlerSaveCorrupted(callback, fileId);
                break;
            }
            case CLOSED: {
                this.handlerClosed(callback, fileId);
                break;
            }
            case FORCESAVE: {
                this.handlerForcesave(callback, fileId);
                break;
            }
            case FORCESAVE_CORRUPTED: {
                this.handlerForcesaveCurrupted(callback, fileId);
                break;
            }
            default: {
                throw new RuntimeException("Callback has no status");
            }
        }
    }

    @Override
    public void handlerEditing(Callback callback, String fileId) throws Exception {
    }

    @Override
    public void handlerSave(Callback callback, String fileId) throws Exception {
    }

    @Override
    public void handlerSaveCorrupted(Callback callback, String fileId) throws Exception {
        this.handlerSave(callback, fileId);
    }

    @Override
    public void handlerClosed(Callback callback, String fileId) throws Exception {
    }

    @Override
    public void handlerForcesave(Callback callback, String fileId) throws Exception {
    }

    @Override
    public void handlerForcesaveCurrupted(Callback callback, String fileId) throws Exception {
        this.handlerForcesave(callback, fileId);
    }

    public DefaultCallbackService(JwtManager jwtManager, SettingsManager settingsManager) {
        this.jwtManager = jwtManager;
        this.settingsManager = settingsManager;
    }

    protected JwtManager getJwtManager() {
        return this.jwtManager;
    }

    protected void setJwtManager(JwtManager jwtManager) {
        this.jwtManager = jwtManager;
    }

    protected SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    protected void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }
}

