/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.model.settings.validation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.onlyoffice.model.common.Error;
import com.onlyoffice.model.settings.validation.status.Status;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class ValidationResult {
    private Status status;
    private Error error;
    private String message;

    ValidationResult(Status status, Error error, String message) {
        this.status = status;
        this.error = error;
        this.message = message;
    }

    public static ValidationResultBuilder builder() {
        return new ValidationResultBuilder();
    }

    public Status getStatus() {
        return this.status;
    }

    public Error getError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static class ValidationResultBuilder {
        private Status status;
        private Error error;
        private String message;

        ValidationResultBuilder() {
        }

        public ValidationResultBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public ValidationResultBuilder error(Error error) {
            this.error = error;
            return this;
        }

        public ValidationResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ValidationResult build() {
            return new ValidationResult(this.status, this.error, this.message);
        }

        public String toString() {
            return "ValidationResult.ValidationResultBuilder(status=" + this.status + ", error=" + this.error + ", message=" + this.message + ")";
        }
    }
}

