/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.model.documenteditor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.onlyoffice.model.documenteditor.config.Document;
import com.onlyoffice.model.documenteditor.config.EditorConfig;
import com.onlyoffice.model.documenteditor.config.document.DocumentType;
import com.onlyoffice.model.documenteditor.config.document.Type;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class Config {
    private DocumentType documentType;
    private String height;
    private String token;
    private Type type;
    private String width;
    private EditorConfig editorConfig;
    private Document document;

    Config(DocumentType documentType, String height, String token, Type type, String width, EditorConfig editorConfig, Document document) {
        this.documentType = documentType;
        this.height = height;
        this.token = token;
        this.type = type;
        this.width = width;
        this.editorConfig = editorConfig;
        this.document = document;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public String getHeight() {
        return this.height;
    }

    public String getToken() {
        return this.token;
    }

    public Type getType() {
        return this.type;
    }

    public String getWidth() {
        return this.width;
    }

    public EditorConfig getEditorConfig() {
        return this.editorConfig;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setEditorConfig(EditorConfig editorConfig) {
        this.editorConfig = editorConfig;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public static class ConfigBuilder {
        private DocumentType documentType;
        private String height;
        private String token;
        private Type type;
        private String width;
        private EditorConfig editorConfig;
        private Document document;

        ConfigBuilder() {
        }

        public ConfigBuilder documentType(DocumentType documentType) {
            this.documentType = documentType;
            return this;
        }

        public ConfigBuilder height(String height) {
            this.height = height;
            return this;
        }

        public ConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public ConfigBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public ConfigBuilder width(String width) {
            this.width = width;
            return this;
        }

        public ConfigBuilder editorConfig(EditorConfig editorConfig) {
            this.editorConfig = editorConfig;
            return this;
        }

        public ConfigBuilder document(Document document) {
            this.document = document;
            return this;
        }

        public Config build() {
            return new Config(this.documentType, this.height, this.token, this.type, this.width, this.editorConfig, this.document);
        }

        public String toString() {
            return "Config.ConfigBuilder(documentType=" + this.documentType + ", height=" + this.height + ", token=" + this.token + ", type=" + this.type + ", width=" + this.width + ", editorConfig=" + this.editorConfig + ", document=" + this.document + ")";
        }
    }
}

