/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util.scheduler;

import com.oceanbase.jdbc.internal.util.scheduler.DynamicSizedSchedulerImpl;
import com.oceanbase.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;
import com.oceanbase.jdbc.internal.util.scheduler.FixedSizedSchedulerImpl;
import com.oceanbase.jdbc.internal.util.scheduler.OceanBaseThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class SchedulerServiceProviderHolder {
    public static final SchedulerProvider DEFAULT_PROVIDER = new SchedulerProvider(){
        private DynamicSizedSchedulerInterface dynamicSizedScheduler;
        private FixedSizedSchedulerImpl fixedSizedScheduler;
        private ScheduledThreadPoolExecutor timeoutScheduler;
        private ThreadPoolExecutor threadPoolExecutor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DynamicSizedSchedulerInterface getScheduler(int minimumThreads, String poolName, int maximumPoolSize) {
            if (this.dynamicSizedScheduler == null) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    if (this.dynamicSizedScheduler == null) {
                        this.dynamicSizedScheduler = new DynamicSizedSchedulerImpl(minimumThreads, poolName, maximumPoolSize);
                    }
                }
            }
            return this.dynamicSizedScheduler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScheduledThreadPoolExecutor getFixedSizeScheduler(int minimumThreads, String poolName) {
            if (this.fixedSizedScheduler == null) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (this.fixedSizedScheduler == null) {
                        this.fixedSizedScheduler = new FixedSizedSchedulerImpl(minimumThreads, poolName);
                    }
                }
            }
            return this.fixedSizedScheduler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScheduledThreadPoolExecutor getTimeoutScheduler() {
            if (this.timeoutScheduler == null) {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.timeoutScheduler == null) {
                        this.timeoutScheduler = new ScheduledThreadPoolExecutor(1, new OceanBaseThreadFactory("MariaDb-timeout"));
                        this.timeoutScheduler.setRemoveOnCancelPolicy(true);
                    }
                }
            }
            return this.timeoutScheduler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ThreadPoolExecutor getBulkScheduler() {
            if (this.threadPoolExecutor == null) {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.threadPoolExecutor == null) {
                        this.threadPoolExecutor = new ThreadPoolExecutor(5, 100, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new OceanBaseThreadFactory("MariaDb-bulk"));
                    }
                }
            }
            return this.threadPoolExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            1 var1_1 = this;
            synchronized (var1_1) {
                if (this.dynamicSizedScheduler != null) {
                    this.dynamicSizedScheduler.shutdownNow();
                }
                if (this.fixedSizedScheduler != null) {
                    this.fixedSizedScheduler.shutdownNow();
                }
                if (this.timeoutScheduler != null) {
                    this.timeoutScheduler.shutdownNow();
                }
                if (this.threadPoolExecutor != null) {
                    this.threadPoolExecutor.shutdownNow();
                }
                this.dynamicSizedScheduler = null;
                this.fixedSizedScheduler = null;
                this.timeoutScheduler = null;
                this.threadPoolExecutor = null;
            }
        }
    };
    private static AtomicReference<SchedulerProvider> currentProvider = new AtomicReference<SchedulerProvider>(DEFAULT_PROVIDER);

    public static SchedulerProvider getSchedulerProvider() {
        return currentProvider.get();
    }

    public static void setSchedulerProvider(SchedulerProvider newProvider) {
        if (newProvider == null) {
            newProvider = DEFAULT_PROVIDER;
        }
        currentProvider.getAndSet(newProvider).close();
    }

    public static void close() {
        currentProvider.get().close();
    }

    public static DynamicSizedSchedulerInterface getScheduler(int initialThreadCount, String poolName, int maximumPoolSize) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getScheduler(initialThreadCount, poolName, maximumPoolSize);
    }

    public static ScheduledExecutorService getFixedSizeScheduler(int initialThreadCount, String poolName) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getFixedSizeScheduler(initialThreadCount, poolName);
    }

    public static ScheduledExecutorService getTimeoutScheduler() {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getTimeoutScheduler();
    }

    public static ThreadPoolExecutor getBulkScheduler() {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getBulkScheduler();
    }

    public static interface SchedulerProvider {
        public DynamicSizedSchedulerInterface getScheduler(int var1, String var2, int var3);

        public ScheduledExecutorService getFixedSizeScheduler(int var1, String var2);

        public ScheduledThreadPoolExecutor getTimeoutScheduler();

        public ThreadPoolExecutor getBulkScheduler();

        public void close();
    }
}

