/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util.constant;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Version {
    public static final String version;
    public static final int majorVersion;
    public static final int minorVersion;
    public static final int patchVersion;
    public static final String qualifier;

    public static int compare(String version1, String version2) {
        try {
            String[] levels1 = version1.split("\\.");
            String[] levels2 = version2.split("\\.");
            int length = Math.max(levels1.length, levels2.length);
            for (int i = 0; i < length; ++i) {
                Integer v2;
                Integer v1 = i < levels1.length ? Integer.parseInt(levels1[i]) : 0;
                int compare = v1.compareTo(v2 = Integer.valueOf(i < levels2.length ? Integer.parseInt(levels2[i]) : 0));
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    static {
        InputStream inputStream = null;
        String tmpVersion = "2.4.3";
        try {
            Properties prop = new Properties();
            inputStream = Version.class.getResourceAsStream("/oceanbase.properties");
            if (inputStream != null) {
                prop.load(inputStream);
                tmpVersion = prop.getProperty("version");
            } else {
                System.out.println("property file 'oceanbase.properties' not found in the classpath");
            }
        }
        catch (Exception prop) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException prop) {}
        }
        version = tmpVersion;
        int major = 0;
        int minor = 0;
        int patch = 0;
        String qualif = "";
        int length = version.length();
        int type = 0;
        int val = 0;
        for (int offset = 0; offset < length; ++offset) {
            char car = version.charAt(offset);
            if (car < '0' || car > '9') {
                switch (type) {
                    case 0: {
                        major = val;
                        break;
                    }
                    case 1: {
                        minor = val;
                        break;
                    }
                    case 2: {
                        patch = val;
                        qualif = version.substring(offset);
                        offset = length;
                        break;
                    }
                }
                ++type;
                val = 0;
                continue;
            }
            val = val * 10 + car - 48;
        }
        if (type == 2) {
            patch = val;
        }
        majorVersion = major;
        minorVersion = minor;
        patchVersion = patch;
        qualifier = qualif;
    }
}

