/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.impl;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.failover.AbstractMastersListener;
import com.oceanbase.jdbc.internal.failover.HandleErrorResult;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceDriver;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceInfo;
import com.oceanbase.jdbc.internal.failover.thread.FailoverLoop;
import com.oceanbase.jdbc.internal.failover.tools.SearchFilter;
import com.oceanbase.jdbc.internal.failover.utils.ConfigParser;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.MasterProtocol;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.constant.HaMode;
import com.oceanbase.jdbc.internal.util.dao.ReconnectDuringTransactionException;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import com.oceanbase.jdbc.internal.util.pool.GlobalStateInfo;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.LinkedList;

public class MastersFailoverListener
extends AbstractMastersListener {
    private static final Logger logger = LoggerFactory.getLogger(MastersFailoverListener.class);
    private final HaMode mode;
    private long ocpTimestamp;

    public MastersFailoverListener(UrlParser urlParser, GlobalStateInfo globalInfo) {
        super(urlParser, globalInfo);
        this.mode = urlParser.getHaMode();
        this.setMasterHostFail();
    }

    @Override
    public void initializeConnection() throws SQLException {
        super.initializeConnection();
        this.currentProtocol = null;
        this.reconnectFailedConnection(new SearchFilter(true, false));
        this.resetMasterFailoverData();
    }

    @Override
    public void preExecute() throws SQLException {
        this.lastQueryNanos = System.nanoTime();
        if (this.currentProtocol != null && this.currentProtocol.isClosed()) {
            this.preAutoReconnect();
        }
    }

    @Override
    public void preClose() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                this.closeConnection(this.currentProtocol);
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public long getServerThreadId() {
        return this.currentProtocol.getServerThreadId();
    }

    @Override
    public void preAbort() {
        if (this.explicitClosed.compareAndSet(false, true)) {
            this.proxy.lock.lock();
            try {
                this.removeListenerFromSchedulers();
                this.abortConnection(this.currentProtocol);
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args, boolean killCmd, boolean alreadyClosed) {
        boolean inTransaction;
        boolean bl = inTransaction = this.currentProtocol != null && this.currentProtocol.inTransaction();
        if (this.currentProtocol.isConnected()) {
            this.currentProtocol.close();
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, false));
            this.handleFailLoop();
            if (killCmd) {
                return new HandleErrorResult(true, false);
            }
            if (alreadyClosed || !inTransaction && this.isQueryRelaunchable(method, args)) {
                logger.info("Connection to master lost, new master {} found, query type permit to be re-execute on new server without throwing exception", (Object)this.currentProtocol.getHostAddress());
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            if (e.getCause() != null && this.proxy.hasToHandleFailover((SQLException)e.getCause()) && this.currentProtocol.isConnected()) {
                this.currentProtocol.close();
            }
            FailoverLoop.removeListener(this);
            return new HandleErrorResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws SQLException {
        this.proxy.lock.lock();
        try {
            if (!(searchFilter.isInitialConnection() || !this.isExplicitClosed() && this.isMasterHostFail())) {
                return;
            }
            this.currentConnectionAttempts.incrementAndGet();
            LinkedList<HostAddress> loopAddress = null;
            if (this.urlParser.getHostAddresses() != null) {
                loopAddress = new LinkedList<HostAddress>(this.urlParser.getHostAddresses());
            }
            if (HaMode.LOADBALANCE.equals((Object)this.mode)) {
                logger.trace("LoadBalance on!");
                LoadBalanceInfo loadBalanceInfo = null;
                try {
                    loadBalanceInfo = this.getGlobalLoadBalanceInfo(this.urlParser);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (loadBalanceInfo == null) {
                    StringBuilder stringBuilder = new StringBuilder("LoadBalance config error ");
                    if (this.urlParser.getExtendDescription() != null) {
                        stringBuilder.append("extend description error :");
                        stringBuilder.append(this.urlParser.getExtendDescription());
                        stringBuilder.append("\n");
                    } else if (this.urlParser.getOcpApi() != null) {
                        stringBuilder.append("OCP API error :");
                        stringBuilder.append(this.urlParser.getOcpApi());
                        stringBuilder.append("\n");
                    } else {
                        stringBuilder.append(" net service name error :");
                        stringBuilder.append(this.urlParser.getTnsServiceName());
                        stringBuilder.append("\n");
                    }
                    logger.error(stringBuilder.toString());
                    throw new SQLException(stringBuilder.toString());
                }
                logger.trace("load balance info =" + loadBalanceInfo.toString());
                LoadBalanceDriver loadBalanceDriver = new LoadBalanceDriver(loadBalanceInfo);
                if (this.urlParser.getOcpApi() == null) {
                    loadBalanceDriver.construct();
                }
                this.setCurrentLoadBalanceInfo(loadBalanceInfo);
                this.setRetryAllDowns(loadBalanceInfo.getRetryAllDowns());
                loadBalanceDriver.loop(this.urlParser, this, this.globalInfo, searchFilter, this.getBlacklist(), this.getPickedlist());
            } else {
                loopAddress.removeAll(this.getBlacklistKeys());
                loopAddress.addAll(this.getBlacklistKeys());
                loopAddress.retainAll(this.urlParser.getHostAddresses());
                if (this.currentProtocol != null && !this.isMasterHostFail()) {
                    loopAddress.remove(this.currentProtocol.getHostAddress());
                }
                MasterProtocol.loop(this, this.globalInfo, loopAddress);
            }
            if (!this.isMasterHostFail()) {
                FailoverLoop.removeListener(this);
            }
            this.resetMasterFailoverData();
        }
        finally {
            this.proxy.lock.unlock();
        }
    }

    private LoadBalanceInfo getGlobalLoadBalanceInfo(UrlParser urlParser) throws SQLException, IOException {
        if (urlParser.getTnsServiceName() != null) {
            return ConfigParser.getLoadBalanceInfoFromTns(urlParser);
        }
        if (urlParser.getExtendDescription() != null) {
            return ConfigParser.getLoadBalanceInfoFromExtendDescription(urlParser);
        }
        if (urlParser.getOcpApi() != null) {
            return ConfigParser.getLoadBalanceInfoFromOcpApi(urlParser.getOcpApi(), urlParser.getOptions());
        }
        return ConfigParser.getLoadBalanceInfoByDefault(urlParser);
    }

    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws SQLException {
        if (this.urlParser.getOptions().assureReadOnly && this.currentReadOnlyAsked != mustBeReadOnly) {
            this.proxy.lock.lock();
            try {
                if (this.currentReadOnlyAsked != mustBeReadOnly) {
                    this.currentReadOnlyAsked = mustBeReadOnly;
                    this.setSessionReadOnly(mustBeReadOnly, this.currentProtocol);
                }
            }
            finally {
                this.proxy.lock.unlock();
            }
        }
    }

    @Override
    public void foundActiveMaster(Protocol protocol) throws SQLException {
        if (this.isExplicitClosed()) {
            this.proxy.lock.lock();
            try {
                protocol.close();
            }
            finally {
                this.proxy.lock.unlock();
            }
            return;
        }
        this.syncConnection(this.currentProtocol, protocol);
        this.proxy.lock.lock();
        try {
            if (this.currentProtocol != null && !this.currentProtocol.isClosed()) {
                this.currentProtocol.close();
            }
            this.currentProtocol = protocol;
        }
        finally {
            this.proxy.lock.unlock();
        }
        this.resetMasterFailoverData();
        FailoverLoop.removeListener(this);
    }

    @Override
    public void reconnect() throws SQLException {
        boolean inTransaction = this.currentProtocol != null && this.currentProtocol.inTransaction();
        this.reconnectFailedConnection(new SearchFilter(true, false));
        this.handleFailLoop();
        if (inTransaction) {
            throw new ReconnectDuringTransactionException("Connection reconnect automatically during an active transaction", 1401, "25S03");
        }
    }

    @Override
    public void handleFailLoop() {
        if (this.isMasterHostFail()) {
            if (!this.isExplicitClosed()) {
                FailoverLoop.addListener(this);
            }
        } else {
            FailoverLoop.removeListener(this);
        }
    }

    @Override
    public boolean isMasterConnected() {
        return this.currentProtocol != null && this.currentProtocol.isConnected();
    }

    @Override
    public boolean checkMasterStatus(SearchFilter searchFilter) {
        if (this.currentProtocol != null) {
            this.pingMasterProtocol(this.currentProtocol);
        }
        return false;
    }

    @Override
    public void rePrepareOnSlave(ServerPrepareResult oldServerPrepareResult, boolean mustExecuteOnSlave) {
    }

    @Override
    public void reset() throws SQLException {
        if (!this.isMasterHostFail()) {
            this.currentProtocol.reset();
        }
    }
}

