/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.impl;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.internal.failover.BlackList.BlackListConfig;
import com.oceanbase.jdbc.internal.failover.LoadBalanceStrategy.BalanceStrategy;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceHostAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LoadBalanceAddressList {
    public BalanceStrategy balanceStrategy;
    public BlackListConfig blackListConfig;
    HashMap<String, String> balanceStrategyConfigs;
    public List<LoadBalanceHostAddress> addressList;

    public LoadBalanceAddressList() {
        this.addressList = new ArrayList<LoadBalanceHostAddress>();
        this.balanceStrategyConfigs = new HashMap();
        this.balanceStrategyConfigs.put("NAME", "DEFAULT");
    }

    public LoadBalanceAddressList(BalanceStrategy balanceStrategy, BlackListConfig blackListConfig, List<LoadBalanceHostAddress> addressList) {
        this.balanceStrategy = balanceStrategy;
        this.blackListConfig = blackListConfig;
        this.addressList = addressList;
    }

    public String toString() {
        return "LoadBalanceAddressList{balanceStrategy=" + this.balanceStrategy + ", blackListConfig=" + this.blackListConfig + ", addressList=" + this.addressList + '}';
    }

    public String toJson() {
        StringBuilder json = new StringBuilder();
        boolean atLeastOneKey = false;
        if (this.balanceStrategy != null) {
            atLeastOneKey = true;
            json.append(this.balanceStrategy.toJson());
        }
        if (this.blackListConfig != null) {
            if (atLeastOneKey) {
                json.append(",");
            } else {
                atLeastOneKey = true;
            }
            json.append(this.blackListConfig.toJson());
        }
        if (this.addressList != null && this.addressList.size() > 0) {
            if (atLeastOneKey) {
                json.append(",");
            }
            json.append("\"ADDRESS\": [");
            boolean atLeastOneAddress = false;
            for (LoadBalanceHostAddress address : this.addressList) {
                if (atLeastOneAddress) {
                    json.append(",");
                } else {
                    atLeastOneAddress = true;
                }
                json.append("{").append(address.toJson()).append("}");
            }
            json.append("]");
        }
        return json.toString();
    }

    public HashMap<String, String> getBalanceStrategyConfigs() {
        return this.balanceStrategyConfigs;
    }

    public void setBalanceStrategyConfigs(HashMap<String, String> balanceStrategyConfigs) {
        this.balanceStrategyConfigs = balanceStrategyConfigs;
    }

    public BalanceStrategy getBalanceStrategy() {
        return this.balanceStrategy;
    }

    public void setBalanceStrategy(BalanceStrategy balanceStrategy) {
        this.balanceStrategy = balanceStrategy;
    }

    public BlackListConfig getBlackListConfig() {
        return this.blackListConfig;
    }

    public void setBlackListConfig(BlackListConfig blackListConfig) {
        this.blackListConfig = blackListConfig;
    }

    public List<LoadBalanceHostAddress> getAddressList() {
        return this.addressList;
    }

    public void setAddressList(List<LoadBalanceHostAddress> addressList) {
        this.addressList = addressList;
    }

    public List<HostAddress> convertToHostAddressList() {
        ArrayList<HostAddress> ret = new ArrayList<HostAddress>();
        for (LoadBalanceHostAddress key : this.addressList) {
            ret.add(key);
        }
        return ret;
    }
}

