/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.authentication.ed25519.spec;

import com.oceanbase.jdbc.internal.com.send.authentication.ed25519.Utils;
import com.oceanbase.jdbc.internal.com.send.authentication.ed25519.math.Curve;
import com.oceanbase.jdbc.internal.com.send.authentication.ed25519.math.Field;
import com.oceanbase.jdbc.internal.com.send.authentication.ed25519.math.ed25519.Ed25519LittleEndianEncoding;
import com.oceanbase.jdbc.internal.com.send.authentication.ed25519.math.ed25519.ScalarOps;
import com.oceanbase.jdbc.internal.com.send.authentication.ed25519.spec.EdDSANamedCurveSpec;
import java.util.Hashtable;
import java.util.Locale;

public class EdDSANamedCurveTable {
    public static final String ED_25519 = "Ed25519";
    private static final Field ed25519field = new Field(256, Utils.hexToBytes("edffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff7f"), new Ed25519LittleEndianEncoding());
    private static final Curve ed25519curve = new Curve(ed25519field, Utils.hexToBytes("a3785913ca4deb75abd841414d0a700098e879777940c78c73fe6f2bee6c0352"), ed25519field.fromByteArray(Utils.hexToBytes("b0a00e4a271beec478e42fad0618432fa7d7fb3d99004d2b0bdfc14f8024832b")));
    private static final EdDSANamedCurveSpec ed25519 = new EdDSANamedCurveSpec("Ed25519", ed25519curve, "SHA-512", new ScalarOps(), ed25519curve.createPoint(Utils.hexToBytes("5866666666666666666666666666666666666666666666666666666666666666"), true));
    private static final Hashtable<String, EdDSANamedCurveSpec> curves = new Hashtable();

    public static void defineCurve(EdDSANamedCurveSpec curve) {
        curves.put(curve.getName().toLowerCase(Locale.ENGLISH), curve);
    }

    static void defineCurveAlias(String name, String alias) {
        EdDSANamedCurveSpec curve = curves.get(name.toLowerCase(Locale.ENGLISH));
        if (curve == null) {
            throw new IllegalStateException();
        }
        curves.put(alias.toLowerCase(Locale.ENGLISH), curve);
    }

    public static EdDSANamedCurveSpec getByName(String name) {
        return curves.get(name.toLowerCase(Locale.ENGLISH));
    }

    static {
        EdDSANamedCurveTable.defineCurve(ed25519);
    }
}

