/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.CallParameter;
import com.oceanbase.jdbc.CallableParameterMetaData;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.ColumnType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;

public class OceanBaseCallableParameterMetaData
extends CallableParameterMetaData {
    protected Map<String, CallParameter> mapNameToParameter;

    public OceanBaseCallableParameterMetaData(OceanBaseConnection con, String database, String name, boolean isFunction) {
        super(con, database, name, isFunction);
    }

    @Override
    public void readMetadataFromDbIfRequired(String query, String arguments, Boolean isObFunction) throws SQLException {
        if (this.valid) {
            return;
        }
        this.query = query;
        this.queryMetaInfos();
        this.resetParams(arguments, isObFunction);
        this.valid = true;
    }

    private void queryMetaInfos() throws SQLException {
        this.mapNameToParameter = new HashMap<String, CallParameter>();
        if (this.name == null || this.name.trim().length() <= 0) {
            return;
        }
        try (Statement stmt = this.con.createStatement();){
            String query_sql = "SELECT DISTINCT(ARGUMENT_NAME), IN_OUT, DATA_TYPE, DATA_PRECISION, DATA_SCALE, POSITION FROM ALL_ARGUMENTS WHERE (OVERLOAD is NULL OR OVERLOAD = 1) and POSITION != 0 AND object_name = '";
            StringBuilder paramMetaSql = new StringBuilder(query_sql);
            paramMetaSql.append(this.name);
            if (this.obOraclePackageName != null && this.obOraclePackageName.trim().length() > 0) {
                paramMetaSql.append("' and package_name = '").append(this.obOraclePackageName);
            }
            if (this.obOracleSchema != null && this.obOracleSchema.trim().length() > 0) {
                String tmp = this.obOracleSchema.startsWith("\"") && this.obOracleSchema.endsWith("\"") ? this.obOracleSchema.replace("\"", "") : this.obOracleSchema.toUpperCase();
                paramMetaSql.append("' and owner =  '").append(tmp);
                paramMetaSql.append("' order by POSITION");
            } else {
                if (this.obOraclePackageName != null) {
                    if (!this.obOraclePackageName.equals("DBMS_LOB")) {
                        paramMetaSql.append("' and owner = SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA')");
                    } else {
                        paramMetaSql.append("' and owner = 'SYS'");
                    }
                } else {
                    paramMetaSql.append("' and owner = SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA')");
                }
                paramMetaSql.append(" order by POSITION");
            }
            ResultSet rs = stmt.executeQuery(paramMetaSql.toString());
            this.addParametersFromDBOD(rs);
        }
        catch (SQLSyntaxErrorException sqlSyntaxErrorException) {
            throw new SQLException("Access to metaData informations not granted for current user. Consider grant select access to mysql.proc  or avoid using parameter by name", sqlSyntaxErrorException);
        }
    }

    private void parseFunctionReturnParam(String functionReturn) throws SQLException {
        if (functionReturn == null || functionReturn.length() == 0) {
            throw new SQLException(this.name + "is not a function returning value");
        }
        Matcher matcher = RETURN_PATTERN.matcher(functionReturn);
        if (!matcher.matches()) {
            throw new SQLException("can not parse return value definition :" + functionReturn);
        }
        CallParameter callParameter = (CallParameter)this.params.get(0);
        callParameter.setOutput(true);
        callParameter.setSigned(matcher.group(1) == null);
        String typeName = matcher.group(2).trim();
        callParameter.setTypeName(typeName);
        int sqlType = ColumnType.convertDbTypeToSqlType(typeName);
        callParameter.setSqlType(sqlType);
        callParameter.setClassName(ColumnType.convertSqlTypeToClass(sqlType).getName());
        String columnSize = matcher.group(3);
        if (columnSize != null) {
            if ((columnSize = columnSize.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                columnSize = columnSize.substring(0, columnSize.indexOf(","));
            }
            callParameter.setPrecision(Integer.parseInt(columnSize));
        }
    }

    private void parseParamList(boolean isFunction, String paramList) throws SQLException {
        this.params = new ArrayList();
        if (isFunction) {
            this.params.add(new CallParameter());
        }
        Matcher matcher2 = PARAMETER_PATTERN.matcher(paramList);
        while (matcher2.find()) {
            CallParameter callParameter = new CallParameter();
            String direction = matcher2.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                callParameter.setInput(true);
            } else if (direction.equalsIgnoreCase("OUT")) {
                callParameter.setOutput(true);
            } else if (direction.equalsIgnoreCase("INOUT")) {
                callParameter.setInput(true);
                callParameter.setOutput(true);
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + callParameter.getName());
            }
            callParameter.setName(matcher2.group(2).trim());
            callParameter.setSigned(matcher2.group(3) == null);
            String typeName = matcher2.group(4).trim().toUpperCase(Locale.ROOT);
            callParameter.setTypeName(typeName);
            int sqlType = ColumnType.convertDbTypeToSqlType(typeName);
            callParameter.setSqlType(sqlType);
            callParameter.setClassName(ColumnType.convertSqlTypeToClass(sqlType).getName());
            String columnSize = matcher2.group(5);
            if (columnSize != null) {
                if ((columnSize = columnSize.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                    columnSize = columnSize.substring(0, columnSize.indexOf(","));
                }
                callParameter.setPrecision(Integer.parseInt(columnSize));
            }
            this.params.add(callParameter);
        }
    }

    private void readMetadata() throws SQLException {
        if (this.valid) {
            return;
        }
        Object metaInfos = null;
        void paramList = metaInfos[0];
        void functionReturn = metaInfos[1];
        this.parseParamList(this.isFunction, (String)paramList);
        if (this.isFunction) {
            this.parseFunctionReturnParam((String)functionReturn);
        }
    }

    @Override
    public CallParameter getParamByName(String name) {
        return this.mapNameToParameter.getOrDefault(name, null);
    }

    private void addParametersFromDBOD(ResultSet paramTypesRs) throws SQLException {
        this.params = new ArrayList();
        if (this.isFunction) {
            CallParameter callParameter = new CallParameter();
            callParameter.setOutput(true);
            callParameter.setInput(false);
            callParameter.setName("functionreturn");
            this.params.add(callParameter);
        }
        int i = 0;
        while (paramTypesRs.next()) {
            String inOut = paramTypesRs.getString("IN_OUT");
            int inOutModifier = 0;
            boolean isOutParameter = false;
            boolean isInParameter = false;
            if (this.getParameterCount() == 0 && this.isFunction) {
                isOutParameter = true;
            } else if (null == inOut || inOut.equalsIgnoreCase("IN")) {
                isInParameter = true;
                inOutModifier = 1;
            } else if (inOut.equalsIgnoreCase("INOUT")) {
                isOutParameter = true;
                isInParameter = true;
                inOutModifier = 2;
            } else if (inOut.equalsIgnoreCase("OUT")) {
                isOutParameter = true;
                inOutModifier = 4;
            } else {
                isInParameter = true;
                inOutModifier = 1;
            }
            String paramName = paramTypesRs.getString("ARGUMENT_NAME");
            String typeName = paramTypesRs.getString("DATA_TYPE");
            int jdbcType = ColumnType.convertDbTypeToSqlType(typeName);
            int precision = paramTypesRs.getInt("DATA_PRECISION");
            int scale = paramTypesRs.getInt("DATA_SCALE");
            int nullability = 1;
            CallParameter paramInfoToAdd = new CallParameter(paramName, i++, isInParameter, isOutParameter, jdbcType, typeName, precision, scale, nullability, jdbcType, inOutModifier);
            this.params.add(paramInfoToAdd);
            this.mapNameToParameter.put(paramName, paramInfoToAdd);
        }
    }
}

