/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

class ObMemLobCommon {
    protected long magic;
    protected byte version;
    protected byte type;
    protected int flags;

    ObMemLobCommon(long magicCode, long version) {
        this.magic = magicCode;
        this.version = (byte)(version & 0xFFL);
        this.type = (byte)(version >> 8 & 0xFL);
        this.flags = (int)(version >> 12 & 0xFFFFFL);
    }

    public boolean hasInrowData() {
        return (this.flags & 2) == 2;
    }

    public boolean isSimple() {
        return (this.flags & 8) == 8;
    }

    public boolean hasExtern() {
        return (this.flags & 0x10) == 16;
    }

    public static class Flag {
        public static final int readOnly = 1;
        public static final int hasInRowData = 2;
        public static final int isOpen = 4;
        public static final int isSimple = 8;
        public static final int hasExtern = 16;
    }
}

