/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.ExceptionInterceptor;
import com.oceanbase.jdbc.LobOutputStream;
import com.oceanbase.jdbc.ObLobLocator;
import com.oceanbase.jdbc.ObLobLocatorV1;
import com.oceanbase.jdbc.ObLobLocatorV2;
import com.oceanbase.jdbc.ObMemLobCommon;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.SQLException;

public abstract class Lob
implements Serializable {
    protected static int DBMS_LOB_MAX_AMOUNT = Short.MAX_VALUE;
    protected byte[] data = null;
    protected transient int offset;
    protected transient int length;
    protected ObLobLocator locator = null;
    protected String encoding = null;
    protected String charData = null;
    protected int lengthFromServer = -1;
    protected ExceptionInterceptor exceptionInterceptor = null;

    public Lob() {
        this.data = new byte[0];
        this.offset = 0;
        this.length = 0;
    }

    public Lob(byte[] bytes) {
        this.data = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public Lob(byte[] bytes, ExceptionInterceptor exceptionInterceptor) {
        this.data = bytes;
        this.offset = 0;
        this.length = bytes.length;
        this.exceptionInterceptor = exceptionInterceptor;
    }

    public Lob(byte[] bytes, int offset, int length) {
        this.data = bytes;
        this.offset = offset;
        this.length = Math.min(bytes.length - offset, length);
    }

    public void copy(Lob lob) {
        this.locator = lob.locator;
        this.data = lob.data;
        this.offset = lob.offset;
        this.length = lob.length;
        this.encoding = lob.encoding;
        this.charData = lob.charData;
        this.lengthFromServer = lob.lengthFromServer;
        this.exceptionInterceptor = lob.exceptionInterceptor;
    }

    public void clearData() {
        this.data = new byte[0];
        this.charData = null;
        this.offset = 0;
        this.length = 0;
    }

    public void buildObLobLocatorV1(boolean isBinary, Buffer buffer, long magicCode, long version, OceanBaseConnection conn) throws SQLException {
        ObLobLocatorV1 locator = new ObLobLocatorV1();
        locator.binaryData = buffer.getByteBuffer();
        locator.magicCode = magicCode;
        locator.version = version;
        locator.snapshotVersion = buffer.readLongV1();
        locator.tableId = buffer.readBytes(8);
        locator.columnId = buffer.readLong4BytesV1();
        locator.flags = buffer.readInt2BytesV1();
        locator.option = buffer.readInt2BytesV1();
        locator.payloadOffset = buffer.readLong4BytesV1();
        locator.payloadSize = buffer.readLong4BytesV1();
        if (locator.payloadSize + locator.payloadOffset <= (long)buffer.remaining()) {
            locator.rowId = buffer.readBytes((int)locator.payloadOffset);
            this.readInRowLobData(isBinary, buffer, locator.payloadSize);
        }
        locator.connection = conn;
        this.locator = locator;
    }

    public void buildObLobLocatorV2(boolean isBinary, Buffer buffer, long magicCode, long version, OceanBaseConnection conn) throws SQLException {
        ObLobLocatorV2 locator = new ObLobLocatorV2();
        ObMemLobCommon common = new ObMemLobCommon(magicCode, version);
        if (common.hasInrowData()) {
            if (common.hasExtern()) {
                buffer.skipBytes(24);
                long payloadOffset = buffer.readLong4BytesV1();
                locator.payloadSize = buffer.readLong4BytesV1();
                if (locator.payloadSize + payloadOffset <= (long)buffer.remaining()) {
                    buffer.skipBytes((int)payloadOffset);
                    this.readInRowLobData(isBinary, buffer, locator.payloadSize);
                }
            } else if (common.isSimple()) {
                locator.payloadSize = buffer.remaining();
                this.readInRowLobData(isBinary, buffer, locator.payloadSize);
            } else if (!common.hasExtern() && !common.isSimple()) {
                buffer.skipByte();
                int lobCommonFlag = buffer.readInt3Bytes();
                if ((lobCommonFlag & 1) == 0) {
                    locator.payloadSize = buffer.remaining();
                    this.readInRowLobData(isBinary, buffer, locator.payloadSize);
                } else {
                    buffer.skipBytes(16);
                    locator.payloadSize = buffer.readLong();
                    this.readInRowLobData(isBinary, buffer, locator.payloadSize);
                }
            }
        } else if (common.hasExtern()) {
            buffer.skipBytes(22);
            int rowkeySize = buffer.readInt2Bytes();
            buffer.skipBytes(8);
            int exSize = buffer.readInt2Bytes();
            buffer.skipBytes(rowkeySize + exSize);
            buffer.skipBytes(4);
            buffer.skipBytes(16);
            locator.payloadSize = buffer.readLong();
        } else {
            buffer.skipBytes(4);
            buffer.skipBytes(16);
            locator.payloadSize = buffer.readLong();
        }
        locator.binaryData = buffer.getByteBuffer();
        locator.common = common;
        locator.connection = conn;
        this.locator = locator;
    }

    private void readInRowLobData(boolean isBinary, Buffer buffer, long lobLength) throws SQLException {
        if (isBinary) {
            this.data = buffer.readBytes((int)lobLength);
            this.length = this.data.length;
        } else {
            try {
                if (lobLength > (long)Clob.maxLength) {
                    throw new SQLException("Exceed max length of Clob for support " + Clob.maxLength + " current " + lobLength);
                }
                this.charData = new String(buffer.readBytes((int)lobLength), this.encoding);
                this.length = this.charData.length();
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Unsupported character encoding " + this.encoding);
            }
        }
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("Invalid position in blob");
        }
        if (this.offset > 0) {
            byte[] tmp = new byte[this.length];
            System.arraycopy(this.data, this.offset, tmp, 0, this.length);
            this.data = tmp;
            this.offset = 0;
        }
        return new LobOutputStream(this, (int)(pos - 1L) + this.offset);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, this.length);
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position should be > 0)");
        }
        if (pos - 1L > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position > stream size)");
        }
        if (pos + length - 1L > (long)this.length) {
            throw ExceptionFactory.INSTANCE.create("Out of range (position + length - 1 > streamSize)");
        }
        return new ByteArrayInputStream(this.data, this.offset + (int)pos - 1, (int)length);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create("pos should be > 0, first position is 1.");
        }
        int arrayPos = (int)pos - 1;
        if (this.length > arrayPos + bytes.length) {
            System.arraycopy(bytes, 0, this.data, this.offset + arrayPos, bytes.length);
        } else {
            byte[] newContent = new byte[arrayPos + bytes.length];
            if (Math.min(arrayPos, this.length) > 0) {
                System.arraycopy(this.data, this.offset, newContent, 0, Math.min(arrayPos, this.length));
            }
            System.arraycopy(bytes, 0, newContent, arrayPos, bytes.length);
            this.data = newContent;
            this.length = arrayPos + bytes.length;
            this.offset = 0;
        }
        this.charData = new String(this.data, Charset.forName(this.encoding == null ? "UTF-8" : this.encoding));
        return bytes.length;
    }

    public void free() {
        this.data = new byte[0];
        this.offset = 0;
        this.length = 0;
    }

    public boolean isEmptyLob() {
        if (this.locator != null) {
            return this.locator.payloadSize == 0L;
        }
        return !(this.data != null && this.data.length != 0 || this.charData != null && this.charData.length() != 0);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionFactory.INSTANCE.create(String.format("Out of range (position should be > 0, but is %s)", pos));
        }
        if (this.length == 0 && !this.isEmptyLob() && this.locator != null && this.locator instanceof ObLobLocatorV2) {
            this.readFromServer();
        }
        int offset = this.offset + (int)(pos - 1L);
        int len = length > this.length ? this.length : length;
        byte[] result = new byte[len];
        System.arraycopy(this.data, offset, result, 0, Math.min(this.length - (int)(pos - 1L), length));
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.offset);
        out.writeInt(this.length);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.offset = in.readInt();
        this.length = in.readInt();
        in.defaultReadObject();
    }

    public synchronized ObLobLocator getLocator() {
        return this.locator;
    }

    protected abstract void readFromServer() throws SQLException;
}

