/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.CallParameter;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.util.ParsedCallParameters;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CallableParameterMetaData
implements ParameterMetaData {
    protected static final Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?(\\`[\\w\\d\\S]+\\`)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    protected static final Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*(CHARSET\\s+)?(\\w+|\\w+\\s+|\\w+\\s+\\w+|\\w+\\s+\\w+\\s+\\w+)?\\s*", 2);
    protected final OceanBaseConnection con;
    protected final String name;
    protected List<CallParameter> params = null;
    protected String obOraclePackageName;
    protected String obOracleSchema;
    protected String database;
    protected boolean valid;
    protected boolean isFunction;
    protected String query;

    public String getProName() {
        return this.name;
    }

    public String getDatabase() {
        return this.database;
    }

    public CallableParameterMetaData(OceanBaseConnection con, String database, String name, boolean isFunction) {
        this.con = con;
        if (database != null) {
            String tmp = database.replace("`", "");
            if (this.con.getProtocol().isOracleMode()) {
                if (tmp.equals(this.con.getProtocol().getDatabase())) {
                    this.database = tmp;
                    this.obOracleSchema = tmp;
                } else if (tmp.contains(".")) {
                    String[] databaseAndPackage = tmp.split("\\.");
                    if (databaseAndPackage.length == 2) {
                        this.obOraclePackageName = databaseAndPackage[1].startsWith("\"") && databaseAndPackage[1].endsWith("\"") ? databaseAndPackage[1].replace("\"", "") : databaseAndPackage[1].toUpperCase(Locale.ROOT);
                        this.obOracleSchema = databaseAndPackage[0].startsWith("\"") && databaseAndPackage[0].endsWith("\"") ? databaseAndPackage[0].replace("\"", "") : databaseAndPackage[0].toUpperCase(Locale.ROOT);
                        this.database = databaseAndPackage[0];
                    }
                } else {
                    if (tmp.startsWith("\"") && tmp.startsWith("\"")) {
                        if (tmp.replace("\"", "").equals(this.con.getProtocol().getDatabase())) {
                            this.obOracleSchema = tmp.replace("\"", "");
                            this.obOraclePackageName = null;
                        } else {
                            this.obOracleSchema = null;
                            this.obOraclePackageName = tmp.replace("\"", "");
                        }
                    } else if (tmp.equals(this.con.getProtocol().getDatabase()) || tmp.toUpperCase(Locale.ROOT).equals(this.con.getProtocol().getDatabase())) {
                        this.obOraclePackageName = null;
                        this.obOracleSchema = tmp.toUpperCase(Locale.ROOT);
                    } else {
                        this.obOraclePackageName = tmp.toUpperCase(Locale.ROOT);
                        this.obOracleSchema = null;
                    }
                    this.database = this.con.getProtocol().getDatabase();
                }
            } else {
                this.database = database;
            }
        } else {
            this.database = null;
        }
        this.name = name.startsWith("\"") && name.endsWith("\"") ? name.replace("`", "").replace("\"", "") : (this.con.getProtocol().isOracleMode() ? name.replace("`", "").toUpperCase(Locale.ROOT) : name);
        this.isFunction = isFunction;
    }

    public void readMetadataFromDbIfRequired() throws SQLException {
        if (this.valid) {
            return;
        }
        this.readMetadata();
        this.valid = true;
    }

    public void generateMetadataFromPrepareResultSet(ServerPrepareResult serverPrepareResult) throws SQLException {
        if (this.valid) {
            return;
        }
        this.params = new ArrayList<CallParameter>();
        ColumnDefinition[] parameters = serverPrepareResult.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            CallParameter callParameter = new CallParameter();
            this.params.add(callParameter);
        }
        this.valid = false;
    }

    public void readMetadataFromDbIfRequired(String query, String arguments, Boolean isObFunction) throws SQLException {
        if (this.valid) {
            return;
        }
        this.query = query;
        this.readMetadata();
        this.resetParams(arguments, isObFunction);
        this.valid = true;
    }

    void resetParams(String arguments, boolean isObFunction) throws SQLException {
        List<Object> paramList = new ArrayList<ParsedCallParameters>();
        if (arguments != null) {
            arguments = Utils.trimSQLString(arguments, false, true, false);
            paramList = Utils.argumentsSplit(arguments, ",", "'\"", "'\"");
        }
        if (isObFunction) {
            paramList.add(0, new ParsedCallParameters(true, "?"));
        }
        int parameterCount = this.params.size();
        int[] placeholderToParameterIndexMap = new int[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            placeholderToParameterIndexMap[i] = -1;
        }
        int placeholderCount = 0;
        for (int i = 0; i < paramList.size(); ++i) {
            if (!((ParsedCallParameters)paramList.get(i)).isParam()) continue;
            placeholderToParameterIndexMap[placeholderCount++] = i;
        }
        ArrayList<CallParameter> currentParams = new ArrayList<CallParameter>(parameterCount);
        for (int index = 0; index < parameterCount; ++index) {
            CallParameter parameter = this.params.get(index);
            boolean found = false;
            for (int placeholderIndex = 0; placeholderIndex <= index; ++placeholderIndex) {
                if (placeholderToParameterIndexMap[placeholderIndex] == index) {
                    found = true;
                    currentParams.add(parameter);
                    break;
                }
                if (placeholderToParameterIndexMap[placeholderIndex] > index || placeholderToParameterIndexMap[placeholderIndex] == -1) break;
            }
            if (found || this.con.getProtocol().isOracleMode() || !parameter.isOutput()) continue;
            throw new SQLException("Parameter " + parameter.getName() + " is not registered as an output parameter.");
        }
        this.params = currentParams;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String[] queryMetaInfos(boolean isFunction) throws SQLException {
        try (PreparedStatement preparedStatement = this.con.prepareStatement("select param_list, returns, db, type from mysql.proc where name=? and db=" + (this.database != null ? "?" : "DATABASE()"));){
            String[] stringArray;
            block16: {
                preparedStatement.setString(1, this.name);
                if (this.database != null) {
                    preparedStatement.setString(2, this.database);
                }
                ResultSet rs = preparedStatement.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new SQLException((isFunction ? "function" : "procedure") + " `" + this.name + "` does not exist");
                    }
                    String paramList = rs.getString(1);
                    String functionReturn = rs.getString(2);
                    this.database = rs.getString(3);
                    this.isFunction = "FUNCTION".equals(rs.getString(4));
                    stringArray = new String[]{paramList, functionReturn};
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return stringArray;
        }
        catch (SQLSyntaxErrorException sqlSyntaxErrorException) {
            throw new SQLException("Access to metaData informations not granted for current user. Consider grant select access to mysql.proc  or avoid using parameter by name", sqlSyntaxErrorException);
        }
    }

    private CallParameter parseFunctionReturnParam(String functionReturn) throws SQLException {
        if (functionReturn == null || functionReturn.length() == 0) {
            throw new SQLException(this.name + "is not a function returning value");
        }
        Matcher matcher = RETURN_PATTERN.matcher(functionReturn);
        if (!matcher.matches()) {
            throw new SQLException("can not parse return value definition :" + functionReturn);
        }
        CallParameter callParameter = new CallParameter();
        callParameter.setOutput(true);
        callParameter.setSigned(matcher.group(1) == null);
        String typeName = matcher.group(2).trim();
        callParameter.setTypeName(typeName);
        int sqlType = ColumnType.convertDbTypeToSqlType(typeName);
        callParameter.setSqlType(sqlType);
        callParameter.setClassName(ColumnType.convertSqlTypeToClass(sqlType).getName());
        String columnSize = matcher.group(3);
        if (columnSize != null) {
            if ((columnSize = columnSize.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                columnSize = columnSize.substring(0, columnSize.indexOf(","));
            }
            callParameter.setPrecision(Integer.parseInt(columnSize));
        }
        return callParameter;
    }

    private void parseParamList(boolean isFunction, String paramList) throws SQLException {
        int returnIndex;
        this.params = new ArrayList<CallParameter>();
        int index = 1;
        if (isFunction && (returnIndex = paramList.indexOf("RETURNS")) != -1) {
            int bodyStartInedx = paramList.toUpperCase(Locale.ROOT).indexOf("BEGIN");
            String returnString = paramList.substring(returnIndex + "RETURNS".length(), bodyStartInedx);
            paramList = paramList.substring(0, returnIndex - 1);
            CallParameter parameterRetrurn = this.parseFunctionReturnParam(returnString);
            parameterRetrurn.setIndex(index++);
            this.params.add(parameterRetrurn);
        }
        Matcher matcher2 = PARAMETER_PATTERN.matcher(paramList);
        while (matcher2.find()) {
            CallParameter callParameter = new CallParameter();
            String direction = matcher2.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                callParameter.setInput(true);
            } else if (direction.equalsIgnoreCase("OUT")) {
                callParameter.setOutput(true);
            } else if (direction.equalsIgnoreCase("INOUT")) {
                callParameter.setInput(true);
                callParameter.setOutput(true);
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + callParameter.getName());
            }
            callParameter.setName(matcher2.group(2).trim());
            callParameter.setSigned(matcher2.group(3) == null);
            String typeName = matcher2.group(4).trim().toUpperCase(Locale.ROOT);
            callParameter.setTypeName(typeName);
            int sqlType = ColumnType.convertDbTypeToSqlType(typeName);
            callParameter.setSqlType(sqlType);
            callParameter.setClassName(ColumnType.convertSqlTypeToClass(sqlType).getName());
            String columnSize = matcher2.group(5);
            if (columnSize != null) {
                if ((columnSize = columnSize.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                    int delimiter = columnSize.indexOf(",");
                    if (delimiter != -1) {
                        callParameter.setScale(Integer.parseInt(columnSize.substring(delimiter + 1)));
                    }
                    columnSize = columnSize.substring(0, delimiter);
                }
                callParameter.setPrecision(Integer.parseInt(columnSize));
            }
            this.params.add(callParameter);
            callParameter.setIndex(index++);
        }
    }

    private void readMetadata() throws SQLException {
        String procedureDDl;
        if (this.name == null || this.name.equals("")) {
            return;
        }
        if (this.isFunction) {
            ResultSet resultSet = this.database != null ? this.con.createStatement().executeQuery("SHOW CREATE FUNCTION " + this.database + "." + this.name) : this.con.createStatement().executeQuery("SHOW CREATE FUNCTION " + this.name);
            resultSet.next();
            procedureDDl = resultSet.getString("Create Function");
        } else {
            ResultSet resultSet = this.database != null ? this.con.createStatement().executeQuery("SHOW CREATE PROCEDURE " + this.database + "." + this.name) : this.con.createStatement().executeQuery("SHOW CREATE PROCEDURE " + this.name);
            resultSet.next();
            procedureDDl = resultSet.getString("Create Procedure");
        }
        String paramList = procedureDDl.substring(procedureDDl.indexOf("(") - 1);
        this.parseParamList(this.isFunction, paramList);
    }

    @Override
    public int getParameterCount() {
        return this.params.size();
    }

    public CallParameter getParamByName(String name) {
        return null;
    }

    public CallParameter getParam(int index) throws SQLException {
        if (index < 1 || index > this.params.size()) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.readMetadataFromDbIfRequired();
        return this.params.get(index - 1);
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParam(param).getCanBeNull();
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParam(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParam(param).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParam(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParam(param).getSqlType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParam(param).getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParam(param).getClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        CallParameter callParameter = this.getParam(param);
        if (callParameter.isInput() && callParameter.isOutput()) {
            return 2;
        }
        if (callParameter.isInput()) {
            return 1;
        }
        if (callParameter.isOutput()) {
            return 4;
        }
        return 0;
    }

    public String getName(int param) throws SQLException {
        return this.getParam(param).getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }
}

