/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.internal.com.read.resultset.ColumnDefinition;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.dao.ServerPrepareResult;
import java.sql.SQLException;

public class AutoGeneratedKey {
    private Protocol protocol;
    private int sqlKind = -1;
    private String originalSql;
    private String simpleSql;
    private String newSql;
    private String tableName;
    int[] columnIndexes;
    String[] columnNames;
    ColumnDefinition[] columns;
    int[] returnTypes;

    public AutoGeneratedKey(String sql, int[] columnIndexes, Protocol protocol) throws SQLException {
        if (sql == null) {
            throw new SQLException("SQL can't be null");
        }
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw new SQLException("columnIndexes can't be empty");
        }
        this.protocol = protocol;
        this.originalSql = sql;
        this.columnIndexes = columnIndexes;
        this.parseSql();
    }

    public AutoGeneratedKey(String sql, String[] columnNames, Protocol protocol) throws SQLException {
        if (sql == null) {
            throw new SQLException("SQL can't be null");
        }
        if (columnNames == null || columnNames.length == 0) {
            throw new SQLException("columnNames can't be empty");
        }
        this.protocol = protocol;
        this.originalSql = sql;
        this.columnNames = columnNames;
        this.parseSql();
    }

    private void parseSql() {
        Utils.TrimSQLInfo tmp = Utils.trimSQLStringInternal(this.originalSql, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), false);
        this.simpleSql = tmp.getTrimedString().toLowerCase();
        this.sqlKind = Utils.getStatementType(this.simpleSql);
    }

    public boolean isInsertSql() {
        return this.sqlKind == 4;
    }

    private String getTableName() throws SQLException {
        int tableEndPos;
        int tableStartPos;
        if (this.tableName != null) {
            return this.tableName;
        }
        int intoStartPos = this.simpleSql.indexOf("into", this.simpleSql.indexOf("insert"));
        if (intoStartPos < 0) {
            throw new SQLException("Failed to find \"insert...into\"");
        }
        for (tableStartPos = intoStartPos + 5; tableStartPos < this.simpleSql.length() && this.simpleSql.charAt(tableStartPos) == ' '; ++tableStartPos) {
        }
        if (tableStartPos >= this.simpleSql.length()) {
            throw new SQLException("Failed to find the start position of table name");
        }
        for (tableEndPos = tableStartPos + 1; tableEndPos < this.simpleSql.length() && this.simpleSql.charAt(tableEndPos) != ' ' && this.simpleSql.charAt(tableEndPos) != '('; ++tableEndPos) {
        }
        if (tableStartPos + 1 == tableEndPos) {
            throw new SQLException("Failed to find the end position of table name");
        }
        this.tableName = this.simpleSql.substring(tableStartPos, tableEndPos);
        return this.tableName;
    }

    public void getColumnDefinition() throws SQLException {
        ServerPrepareResult serverPrepareResult = this.protocol.prepare("select * from " + this.getTableName(), this.protocol.isMasterConnection());
        this.columns = serverPrepareResult.getColumns();
        this.protocol.releasePrepareStatement(serverPrepareResult);
    }

    public String getNewSqlByIndex() throws SQLException {
        if (this.newSql != null) {
            return this.newSql;
        }
        this.getColumnDefinition();
        StringBuilder returningBuilder = new StringBuilder(this.originalSql);
        returningBuilder.append(" returning ");
        StringBuilder intoBuilder = new StringBuilder(" into ");
        this.returnTypes = new int[this.columnIndexes.length];
        for (int i = 0; i < this.columnIndexes.length; ++i) {
            int index;
            if (i != 0) {
                returningBuilder.append(", ");
                intoBuilder.append(", ");
            }
            if ((index = this.columnIndexes[i] - 1) < 0 || index >= this.columns.length) {
                throw new ArrayIndexOutOfBoundsException("index " + index + " must be in [0, " + (this.columns.length - 1) + "]");
            }
            this.returnTypes[i] = this.columns[index].getSqltype();
            returningBuilder.append(this.columns[index].getOriginalName());
            intoBuilder.append('?');
        }
        this.sqlKind = -1;
        this.newSql = returningBuilder.toString() + intoBuilder.toString();
        return this.newSql;
    }

    public String getNewSqlByName() throws SQLException {
        if (this.newSql != null) {
            return this.newSql;
        }
        this.getColumnDefinition();
        StringBuilder returningBuilder = new StringBuilder(this.originalSql);
        returningBuilder.append(" returning ");
        StringBuilder intoBuilder = new StringBuilder(" into ");
        this.returnTypes = new int[this.columnNames.length];
        this.columnIndexes = new int[this.columnNames.length];
        for (int keyNo = 0; keyNo < this.columnNames.length; ++keyNo) {
            if (keyNo != 0) {
                returningBuilder.append(", ");
                intoBuilder.append(", ");
            }
            boolean found = false;
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columnNames[keyNo].equalsIgnoreCase(this.columns[i].getOriginalName())) continue;
                found = true;
                this.columnIndexes[keyNo] = i + 1;
                this.returnTypes[keyNo] = this.columns[i].getSqltype();
            }
            if (!found) {
                throw new SQLException("Invalid parameter \"" + this.columnNames[keyNo] + "\"");
            }
            returningBuilder.append(this.columnNames[keyNo]);
            intoBuilder.append('?');
        }
        this.sqlKind = -1;
        this.newSql = returningBuilder.toString() + intoBuilder.toString();
        return this.newSql;
    }
}

