/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.rtc.room;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.rtc.RtcResult;
import com.netease.nim.server.sdk.rtc.room.IRtcRoomService;
import com.netease.nim.server.sdk.rtc.room.request.RtcCreateRoomRequest;
import com.netease.nim.server.sdk.rtc.room.request.RtcGetRoomByCidRequest;
import com.netease.nim.server.sdk.rtc.room.request.RtcGetRoomByCnameRequest;
import com.netease.nim.server.sdk.rtc.room.response.RtcCreateRoomResponse;
import com.netease.nim.server.sdk.rtc.room.response.RtcGetRoomResponse;
import java.util.HashMap;

public class RtcRoomService
implements IRtcRoomService {
    private final YunxinApiHttpClient httpClient;

    public RtcRoomService(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public RtcResult<RtcCreateRoomResponse> createRoom(RtcCreateRoomRequest request) {
        String msg;
        String body = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse response = this.httpClient.executeJson(HttpMethod.POST, "/v2/api/room", null, body);
        int httpCode = response.getHttpCode();
        int code = 0;
        String requestId = null;
        RtcCreateRoomResponse createRoomResponse = null;
        try {
            JSONObject json = JSONObject.parseObject((String)response.getData());
            code = json.getIntValue("code");
            requestId = json.getString("requestId");
            msg = json.getString("errmsg");
            createRoomResponse = (RtcCreateRoomResponse)JSONObject.parseObject((String)response.getData(), RtcCreateRoomResponse.class);
        }
        catch (Exception e) {
            msg = response.getData();
        }
        return new RtcResult<Object>(response.getEndpoint(), code, httpCode, requestId, response.getTraceId(), msg, createRoomResponse);
    }

    @Override
    public RtcResult<RtcGetRoomResponse> getRoomByCid(RtcGetRoomByCidRequest request) {
        String msg;
        String path = "/v2/api/rooms/{cid}".replace("{cid}", String.valueOf(request.getCid()));
        YunxinApiResponse response = this.httpClient.executeJson(HttpMethod.GET, "/v2/api/rooms/{cid}", path, null, null);
        int httpCode = response.getHttpCode();
        int code = 0;
        String requestId = null;
        RtcGetRoomResponse getRoomResponse = null;
        try {
            JSONObject json = JSONObject.parseObject((String)response.getData());
            code = json.getIntValue("code");
            requestId = json.getString("requestId");
            msg = json.getString("errmsg");
            getRoomResponse = (RtcGetRoomResponse)JSONObject.parseObject((String)response.getData(), RtcGetRoomResponse.class);
        }
        catch (Exception e) {
            msg = response.getData();
        }
        return new RtcResult<Object>(response.getEndpoint(), code, httpCode, requestId, response.getTraceId(), msg, getRoomResponse);
    }

    @Override
    public RtcResult<RtcGetRoomResponse> getRoomByCname(RtcGetRoomByCnameRequest request) {
        String msg;
        HashMap<String, String> queryString = new HashMap<String, String>();
        queryString.put("cname", request.getCname());
        YunxinApiResponse response = this.httpClient.executeJson(HttpMethod.GET, "/v3/api/rooms", queryString, null);
        int httpCode = response.getHttpCode();
        int code = 0;
        String requestId = null;
        RtcGetRoomResponse getRoomResponse = null;
        try {
            JSONObject json = JSONObject.parseObject((String)response.getData());
            code = json.getIntValue("code");
            requestId = json.getString("requestId");
            msg = json.getString("errmsg");
            getRoomResponse = (RtcGetRoomResponse)JSONObject.parseObject((String)response.getData(), RtcGetRoomResponse.class);
        }
        catch (Exception e) {
            msg = response.getData();
        }
        return new RtcResult<Object>(response.getEndpoint(), code, httpCode, requestId, response.getTraceId(), msg, getRoomResponse);
    }
}

