/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.users;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.users.IUserV2Service;
import com.netease.nim.server.sdk.im.v2.users.request.BatchGetUsersRequestV2;
import com.netease.nim.server.sdk.im.v2.users.request.GetUserOnlineStatusRequestV2;
import com.netease.nim.server.sdk.im.v2.users.request.GetUserRequestV2;
import com.netease.nim.server.sdk.im.v2.users.request.UpdateUserRequestV2;
import com.netease.nim.server.sdk.im.v2.users.response.BatchGetUsersResponseV2;
import com.netease.nim.server.sdk.im.v2.users.response.GetUserOnlineStatusResponseV2;
import com.netease.nim.server.sdk.im.v2.users.response.GetUserResponseV2;
import com.netease.nim.server.sdk.im.v2.users.response.UpdateUserResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class UserV2Service
implements IUserV2Service {
    private final YunxinApiHttpClient httpClient;

    public UserV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<UpdateUserResponseV2> updateUser(UpdateUserRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/users/{account_id}".replace("{account_id}", request.getAccountId());
        JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        data.remove((Object)"accountId");
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/users/{account_id}", path, null, data.toString());
        return ResultUtils.convert(apiResponse, UpdateUserResponseV2.class);
    }

    @Override
    public Result<GetUserResponseV2> getUser(GetUserRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/users/{account_id}".replace("{account_id}", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/users/{account_id}", path, null, null);
        return ResultUtils.convert(apiResponse, GetUserResponseV2.class);
    }

    @Override
    public Result<BatchGetUsersResponseV2> batchGetUsers(BatchGetUsersRequestV2 request) throws YunxinSdkException {
        String accountIdsString = String.join((CharSequence)",", request.getAccountIds());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_ids", accountIdsString);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/users", "/im/v2/users", queryParams, null);
        return ResultUtils.convert(apiResponse, BatchGetUsersResponseV2.class);
    }

    @Override
    public Result<GetUserOnlineStatusResponseV2> getUsersOnlineStatus(GetUserOnlineStatusRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/users/actions/online_status", "/im/v2/users/actions/online_status", null, requestBody);
        return ResultUtils.convert(apiResponse, GetUserOnlineStatusResponseV2.class);
    }
}

