/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.tool;

import com.alibaba.fastjson2.JSON;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.tool.IToolV2Service;
import com.netease.nim.server.sdk.im.v2.tool.request.AsrRequestV2;
import com.netease.nim.server.sdk.im.v2.tool.response.AsrResponseV2;
import com.netease.nim.server.sdk.im.v2.translation.request.TranslateTextRequestV2;
import com.netease.nim.server.sdk.im.v2.translation.response.TranslateTextResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;

public class ToolV2Service
implements IToolV2Service {
    private final YunxinApiHttpClient yunxinApiHttpClient;

    public ToolV2Service(YunxinApiHttpClient yunxinApiHttpClient) {
        this.yunxinApiHttpClient = yunxinApiHttpClient;
    }

    @Override
    public Result<AsrResponseV2> asr(AsrRequestV2 request) throws YunxinSdkException {
        if (request.getOperatorAccountId() == null) {
            throw new IllegalArgumentException("operator_account_id cannot be empty");
        }
        if (request.getFormat() == null) {
            throw new IllegalArgumentException("format cannot be empty");
        }
        if (request.getUrl() == null) {
            throw new IllegalArgumentException("url cannot be empty");
        }
        String body = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.POST, "/im/v2/tools/asr", "/im/v2/tools/asr", null, body);
        return ResultUtils.convert(apiResponse, AsrResponseV2.class);
    }

    @Override
    public Result<TranslateTextResponseV2> translateText(TranslateTextRequestV2 request) throws YunxinSdkException {
        if (request.getOperatorAccountId() == null || request.getOperatorAccountId().isEmpty()) {
            throw new IllegalArgumentException("Operator account ID cannot be null or empty");
        }
        if (request.getSourceText() == null || request.getSourceText().isEmpty()) {
            throw new IllegalArgumentException("Source text cannot be null or empty");
        }
        if (request.getTargetLanguage() == null || request.getTargetLanguage().isEmpty()) {
            throw new IllegalArgumentException("Target language cannot be null or empty");
        }
        if (request.getSourceLanguage() == null || request.getSourceLanguage().isEmpty()) {
            request.setSourceLanguage("auto");
        }
        String jsonRequestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.POST, "/im/v2/translations", "/im/v2/translations", null, jsonRequestBody);
        return ResultUtils.convert(apiResponse, TranslateTextResponseV2.class);
    }
}

