/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.team;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.team.ITeamV2Service;
import com.netease.nim.server.sdk.im.v2.team.request.AddTeamManagersRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.BatchQueryTeamInfoRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.BatchQueryTeamOnlineMembersCountRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.CreateTeamRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.DisbandTeamRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.GetTeamInfoRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.ListOnlineTeamMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.ListTeamMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.RemoveTeamManagersRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.TransferTeamOwnerRequestV2;
import com.netease.nim.server.sdk.im.v2.team.request.UpdateTeamRequestV2;
import com.netease.nim.server.sdk.im.v2.team.response.AddTeamManagersResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.BatchQueryTeamInfoResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.BatchQueryTeamOnlineMembersCountResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.CreateTeamResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.DisbandTeamResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.GetTeamInfoResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.ListOnlineTeamMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.ListTeamMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.RemoveTeamManagersResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.TransferTeamOwnerResponseV2;
import com.netease.nim.server.sdk.im.v2.team.response.UpdateTeamResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;
import java.util.stream.Collectors;

public class TeamV2Service
implements ITeamV2Service {
    private final YunxinApiHttpClient httpClient;

    public TeamV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateTeamResponseV2> createTeam(CreateTeamRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2.1/teams", "/im/v2.1/teams", null, requestBody);
        return ResultUtils.convert(apiResponse, CreateTeamResponseV2.class);
    }

    @Override
    public Result<UpdateTeamResponseV2> updateTeam(UpdateTeamRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2.1/teams/{team_id}".replace("{team_id}", String.valueOf(request.getTeamId()));
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, path, path, null, requestBody);
        return ResultUtils.convert(apiResponse, UpdateTeamResponseV2.class);
    }

    @Override
    public Result<DisbandTeamResponseV2> disbandTeam(DisbandTeamRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamId() == null) {
            throw new IllegalArgumentException("Team ID cannot be null");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1 && request.getTeamType() != 2) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team) or 2 (Super team)");
        }
        String path = "/im/v2.1/teams/{team_id}".replace("{team_id}", request.getTeamId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (request.getOperatorId() != null) {
            queryParams.put("operator_id", request.getOperatorId());
        }
        if (request.getTeamType() != null) {
            queryParams.put("team_type", String.valueOf(request.getTeamType()));
        }
        if (request.getExtension() != null) {
            queryParams.put("extension", request.getExtension());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, path, path, queryParams, null);
        return ResultUtils.convert(apiResponse, DisbandTeamResponseV2.class);
    }

    @Override
    public Result<BatchQueryTeamInfoResponseV2> batchQueryTeamInfo(BatchQueryTeamInfoRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamIds() == null || request.getTeamIds().isEmpty()) {
            throw new IllegalArgumentException("Team IDs list cannot be null or empty");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1 && request.getTeamType() != 2) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team) or 2 (Super team)");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("team_type", request.getTeamType().toString());
        queryParams.put("team_ids", JSONObject.toJSONString(request.getTeamIds(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/teams", "/im/v2.1/teams", queryParams, null);
        return ResultUtils.convert(apiResponse, BatchQueryTeamInfoResponseV2.class);
    }

    @Override
    public Result<TransferTeamOwnerResponseV2> transferOwner(TransferTeamOwnerRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamId() == null) {
            throw new IllegalArgumentException("Team ID cannot be null");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1 && request.getTeamType() != 2) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team) or 2 (Super team)");
        }
        if (request.getNewOwnerAccountId() == null || request.getNewOwnerAccountId().isEmpty()) {
            throw new IllegalArgumentException("New owner account ID cannot be null or empty");
        }
        if (request.getLeave() == null) {
            throw new IllegalArgumentException("Leave parameter cannot be null");
        }
        if (request.getLeave() != 1 && request.getLeave() != 2) {
            throw new IllegalArgumentException("Invalid leave parameter: must be 1 (Leave) or 2 (Stay as a regular member)");
        }
        String path = "/im/v2/teams/{team_id}/actions/transfer_owner".replace("{team_id}", request.getTeamId().toString());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/teams/{team_id}/actions/transfer_owner", path, null, requestBody);
        return ResultUtils.convert(apiResponse, TransferTeamOwnerResponseV2.class);
    }

    @Override
    public Result<AddTeamManagersResponseV2> addManagers(AddTeamManagersRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamId() == null) {
            throw new IllegalArgumentException("Team ID cannot be null");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1 && request.getTeamType() != 2) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team) or 2 (Super team)");
        }
        if (request.getManagers() == null || request.getManagers().isEmpty()) {
            throw new IllegalArgumentException("Managers list cannot be null or empty");
        }
        String path = "/im/v2/teams/{team_id}/actions/add_manager".replace("{team_id}", request.getTeamId().toString());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/teams/{team_id}/actions/add_manager", path, null, requestBody);
        return ResultUtils.convert(apiResponse, AddTeamManagersResponseV2.class);
    }

    @Override
    public Result<RemoveTeamManagersResponseV2> removeManagers(RemoveTeamManagersRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamId() == null) {
            throw new IllegalArgumentException("Team ID cannot be null");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1 && request.getTeamType() != 2) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team) or 2 (Super team)");
        }
        if (request.getManagers() == null || request.getManagers().isEmpty()) {
            throw new IllegalArgumentException("Managers list cannot be null or empty");
        }
        String path = "/im/v2/teams/{team_id}/actions/remove_manager".replace("{team_id}", request.getTeamId().toString());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/teams/{team_id}/actions/remove_manager", path, null, requestBody);
        return ResultUtils.convert(apiResponse, RemoveTeamManagersResponseV2.class);
    }

    @Override
    public Result<GetTeamInfoResponseV2> getTeamInfo(GetTeamInfoRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamId() == null) {
            throw new IllegalArgumentException("Team ID cannot be null");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1 && request.getTeamType() != 2) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team) or 2 (Super team)");
        }
        String path = "/im/v2.1/teams/{team_id}".replace("{team_id}", request.getTeamId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("team_type", request.getTeamType().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/teams/{team_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, GetTeamInfoResponseV2.class);
    }

    @Override
    public Result<ListTeamMembersResponseV2> listTeamMembers(ListTeamMembersRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamId() == null) {
            throw new IllegalArgumentException("Team ID cannot be null");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1 && request.getTeamType() != 2) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team) or 2 (Super team)");
        }
        if (request.getMemberType() != null && (request.getMemberType() < 0 || request.getMemberType() > 2)) {
            throw new IllegalArgumentException("Invalid member type: must be 0 (All), 1 (Owner/Managers), or 2 (Regular members)");
        }
        if (request.getChatBannedType() != null && (request.getChatBannedType() < 0 || request.getChatBannedType() > 2)) {
            throw new IllegalArgumentException("Invalid chat banned type: must be 0 (All), 1 (Banned), or 2 (Not banned)");
        }
        String path = "/im/v2.1/teams/{team_id}/actions/list_members".replace("{team_id}", request.getTeamId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("team_type", request.getTeamType().toString());
        if (request.getMemberType() != null) {
            queryParams.put("member_type", request.getMemberType().toString());
        }
        if (request.getChatBannedType() != null) {
            queryParams.put("chat_banned_type", request.getChatBannedType().toString());
        }
        if (request.getDescending() != null) {
            queryParams.put("descending", request.getDescending().toString());
        }
        if (request.getPageToken() != null && !request.getPageToken().isEmpty()) {
            queryParams.put("page_token", request.getPageToken());
        }
        if (request.getLimit() != null) {
            queryParams.put("limit", request.getLimit().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/teams/{team_id}/actions/list_members", path, queryParams, null);
        return ResultUtils.convert(apiResponse, ListTeamMembersResponseV2.class);
    }

    @Override
    public Result<ListOnlineTeamMembersResponseV2> listOnlineTeamMembers(ListOnlineTeamMembersRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamId() == null) {
            throw new IllegalArgumentException("Team ID cannot be null");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team). Currently, this API only supports Advanced Teams.");
        }
        String path = "/im/v2/teams/{team_id}/actions/list_online_members".replace("{team_id}", request.getTeamId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("team_type", request.getTeamType().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/teams/{team_id}/actions/list_online_members", path, queryParams, null);
        return ResultUtils.convert(apiResponse, ListOnlineTeamMembersResponseV2.class);
    }

    @Override
    public Result<BatchQueryTeamOnlineMembersCountResponseV2> batchQueryTeamOnlineMembersCount(BatchQueryTeamOnlineMembersCountRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getTeamIds() == null || request.getTeamIds().isEmpty()) {
            throw new IllegalArgumentException("Team IDs list cannot be null or empty");
        }
        if (request.getTeamType() == null) {
            throw new IllegalArgumentException("Team type cannot be null");
        }
        if (request.getTeamType() != 1) {
            throw new IllegalArgumentException("Invalid team type: must be 1 (Advanced team). Currently, this API only supports Advanced Teams.");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("team_type", request.getTeamType().toString());
        queryParams.put("team_ids", request.getTeamIds().stream().map(String::valueOf).collect(Collectors.joining(",")));
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/teams/actions/online_members_count", "/im/v2/teams/actions/online_members_count", queryParams, null);
        return ResultUtils.convert(apiResponse, BatchQueryTeamOnlineMembersCountResponseV2.class);
    }
}

