/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.system_notification;

import com.alibaba.fastjson2.JSON;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.system_notification.ICustomNotificationV2Service;
import com.netease.nim.server.sdk.im.v2.system_notification.request.SendBatchCustomNotificationRequestV2;
import com.netease.nim.server.sdk.im.v2.system_notification.request.SendCustomNotificationRequestV2;
import com.netease.nim.server.sdk.im.v2.system_notification.response.SendBatchCustomNotificationResponseV2;
import com.netease.nim.server.sdk.im.v2.system_notification.response.SendCustomNotificationResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;

public class CustomNotificationV2Service
implements ICustomNotificationV2Service {
    private final YunxinApiHttpClient yunxinApiHttpClient;

    public CustomNotificationV2Service(YunxinApiHttpClient yunxinApiHttpClient) {
        this.yunxinApiHttpClient = yunxinApiHttpClient;
    }

    @Override
    public Result<SendCustomNotificationResponseV2> sendCustomNotification(SendCustomNotificationRequestV2 request) throws YunxinSdkException {
        if (request.getSenderId() == null || request.getSenderId().isEmpty()) {
            throw new IllegalArgumentException("Sender ID cannot be null or empty");
        }
        if (request.getType() == null) {
            throw new IllegalArgumentException("Notification type cannot be null");
        }
        if (request.getType() < 1 || request.getType() > 3) {
            throw new IllegalArgumentException("Invalid notification type: must be 1 (P2P), 2 (Team), or 3 (Superteam)");
        }
        if (request.getReceiverId() == null || request.getReceiverId().isEmpty()) {
            throw new IllegalArgumentException("Receiver ID cannot be null or empty");
        }
        if (request.getContent() == null || request.getContent().isEmpty()) {
            throw new IllegalArgumentException("Content cannot be null or empty");
        }
        String jsonRequestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.POST, "/im/v2/custom_notification", "/im/v2/custom_notification", null, jsonRequestBody);
        return ResultUtils.convert(apiResponse, SendCustomNotificationResponseV2.class);
    }

    @Override
    public Result<SendBatchCustomNotificationResponseV2> sendBatchCustomNotification(SendBatchCustomNotificationRequestV2 request) throws YunxinSdkException {
        if (request.getSenderId() == null || request.getSenderId().isEmpty()) {
            throw new IllegalArgumentException("Sender ID cannot be null or empty");
        }
        if (request.getReceiverIds() == null || request.getReceiverIds().isEmpty()) {
            throw new IllegalArgumentException("Receiver IDs cannot be null or empty");
        }
        if (request.getContent() == null || request.getContent().isEmpty()) {
            throw new IllegalArgumentException("Content cannot be null or empty");
        }
        String jsonRequestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.POST, "/im/v2/custom_notification/batch", "/im/v2/custom_notification/batch", null, jsonRequestBody);
        return ResultUtils.convert(apiResponse, SendBatchCustomNotificationResponseV2.class);
    }
}

