/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.subscription;

import com.alibaba.fastjson2.JSON;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.subscription.ISubscriptionV2Service;
import com.netease.nim.server.sdk.im.v2.subscription.request.QueryUserStatusSubscriptionRequestV2;
import com.netease.nim.server.sdk.im.v2.subscription.request.SubscribeUserStatusRequestV2;
import com.netease.nim.server.sdk.im.v2.subscription.request.UnsubscribeUserStatusRequestV2;
import com.netease.nim.server.sdk.im.v2.subscription.response.QueryUserStatusSubscriptionResponseV2;
import com.netease.nim.server.sdk.im.v2.subscription.response.SubscribeUserStatusResponseV2;
import com.netease.nim.server.sdk.im.v2.subscription.response.UnsubscribeUserStatusResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class SubscriptionV2Service
implements ISubscriptionV2Service {
    private final YunxinApiHttpClient yunxinApiHttpClient;

    public SubscriptionV2Service(YunxinApiHttpClient yunxinApiHttpClient) {
        this.yunxinApiHttpClient = yunxinApiHttpClient;
    }

    @Override
    public Result<SubscribeUserStatusResponseV2> subscribeUserStatus(SubscribeUserStatusRequestV2 request) throws YunxinSdkException {
        if (request.getSubscriberAccountId() == null || request.getSubscriberAccountId().isEmpty()) {
            throw new IllegalArgumentException("Subscriber account ID cannot be null or empty");
        }
        if (request.getDuration() == null) {
            throw new IllegalArgumentException("Duration cannot be null");
        }
        if (request.getAccountIds() == null || request.getAccountIds().isEmpty()) {
            throw new IllegalArgumentException("Account IDs list cannot be null or empty");
        }
        String url = "/im/v2/subscription/{account_id}".replace("{account_id}", request.getSubscriberAccountId());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("duration", String.valueOf(request.getDuration()));
        String jsonRequestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.POST, "/im/v2/subscription/{account_id}", url, queryParams, jsonRequestBody);
        return ResultUtils.convert(apiResponse, SubscribeUserStatusResponseV2.class);
    }

    @Override
    public Result<UnsubscribeUserStatusResponseV2> unsubscribeUserStatus(UnsubscribeUserStatusRequestV2 request) throws YunxinSdkException {
        if (request.getSubscriberAccountId() == null || request.getSubscriberAccountId().isEmpty()) {
            throw new IllegalArgumentException("Subscriber account ID cannot be null or empty");
        }
        String url = "/im/v2/subscription/{account_id}".replace("{account_id}", request.getSubscriberAccountId());
        String jsonRequestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/subscription/{account_id}", url, null, jsonRequestBody);
        return ResultUtils.convert(apiResponse, UnsubscribeUserStatusResponseV2.class);
    }

    @Override
    public Result<QueryUserStatusSubscriptionResponseV2> queryUserStatusSubscription(QueryUserStatusSubscriptionRequestV2 request) throws YunxinSdkException {
        if (request.getSubscriberAccountId() == null || request.getSubscriberAccountId().isEmpty()) {
            throw new IllegalArgumentException("Subscriber account ID cannot be null or empty");
        }
        if (request.getAccountIds() == null || request.getAccountIds().isEmpty()) {
            throw new IllegalArgumentException("Account IDs list cannot be null or empty");
        }
        String url = "/im/v2/subscription/{account_id}".replace("{account_id}", request.getSubscriberAccountId());
        String jsonRequestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.yunxinApiHttpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/subscription/{account_id}", url, null, jsonRequestBody);
        return ResultUtils.convert(apiResponse, QueryUserStatusSubscriptionResponseV2.class);
    }
}

