/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.message.request;

import com.alibaba.fastjson2.annotation.JSONField;
import java.util.List;
import java.util.Map;

public class SendMessageRequestV2 {
    @JSONField(name="conversation_id")
    private String conversationId;
    @JSONField(name="message")
    private MessageBody message;
    @JSONField(name="message_config")
    private MessageConfig messageConfig;
    @JSONField(name="target_option")
    private TargetOption targetOption;
    @JSONField(name="route_config")
    private RouteConfig routeConfig;
    @JSONField(name="push_config")
    private PushConfig pushConfig;
    @JSONField(name="antispam_config")
    private AntispamConfig antispamConfig;
    @JSONField(name="p2p_option")
    private P2POption p2pOption;
    @JSONField(name="team_option")
    private TeamOption teamOption;
    @JSONField(name="superteam_option")
    private SuperTeamOption superteamOption;
    @JSONField(name="robot_config")
    private RobotConfig robotConfig;
    @JSONField(name="thread_config")
    private ThreadConfig threadConfig;
    @JSONField(name="sender_no_sense")
    private Boolean senderNoSense;
    @JSONField(name="receiver_no_sense")
    private Boolean receiverNoSense;
    @JSONField(name="extension")
    private String extension;
    @JSONField(name="ai_params")
    private AIParams aiParams;

    public static SendMessageRequestV2 createTextMessage(String conversationId, String text) {
        SendMessageRequestV2 request = new SendMessageRequestV2();
        request.setConversationId(conversationId);
        MessageBody message = new MessageBody();
        message.setMessageType(0);
        message.setText(text);
        request.setMessage(message);
        return request;
    }

    public static SendMessageRequestV2 createCustomMessage(String conversationId, Map<?, ?> attachment, Integer subType) {
        SendMessageRequestV2 request = new SendMessageRequestV2();
        request.setConversationId(conversationId);
        MessageBody message = new MessageBody();
        message.setMessageType(100);
        message.setAttachment(attachment);
        if (subType != null) {
            message.setSubType(subType);
        }
        request.setMessage(message);
        return request;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public MessageBody getMessage() {
        return this.message;
    }

    public void setMessage(MessageBody message) {
        this.message = message;
    }

    public MessageConfig getMessageConfig() {
        return this.messageConfig;
    }

    public void setMessageConfig(MessageConfig messageConfig) {
        this.messageConfig = messageConfig;
    }

    public TargetOption getTargetOption() {
        return this.targetOption;
    }

    public void setTargetOption(TargetOption targetOption) {
        this.targetOption = targetOption;
    }

    public RouteConfig getRouteConfig() {
        return this.routeConfig;
    }

    public void setRouteConfig(RouteConfig routeConfig) {
        this.routeConfig = routeConfig;
    }

    public PushConfig getPushConfig() {
        return this.pushConfig;
    }

    public void setPushConfig(PushConfig pushConfig) {
        this.pushConfig = pushConfig;
    }

    public AntispamConfig getAntispamConfig() {
        return this.antispamConfig;
    }

    public void setAntispamConfig(AntispamConfig antispamConfig) {
        this.antispamConfig = antispamConfig;
    }

    public P2POption getP2pOption() {
        return this.p2pOption;
    }

    public void setP2pOption(P2POption p2pOption) {
        this.p2pOption = p2pOption;
    }

    public TeamOption getTeamOption() {
        return this.teamOption;
    }

    public void setTeamOption(TeamOption teamOption) {
        this.teamOption = teamOption;
    }

    public SuperTeamOption getSuperteamOption() {
        return this.superteamOption;
    }

    public void setSuperteamOption(SuperTeamOption superteamOption) {
        this.superteamOption = superteamOption;
    }

    public RobotConfig getRobotConfig() {
        return this.robotConfig;
    }

    public void setRobotConfig(RobotConfig robotConfig) {
        this.robotConfig = robotConfig;
    }

    public ThreadConfig getThreadConfig() {
        return this.threadConfig;
    }

    public void setThreadConfig(ThreadConfig threadConfig) {
        this.threadConfig = threadConfig;
    }

    public Boolean getSenderNoSense() {
        return this.senderNoSense;
    }

    public void setSenderNoSense(Boolean senderNoSense) {
        this.senderNoSense = senderNoSense;
    }

    public Boolean getReceiverNoSense() {
        return this.receiverNoSense;
    }

    public void setReceiverNoSense(Boolean receiverNoSense) {
        this.receiverNoSense = receiverNoSense;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public AIParams getAiParams() {
        return this.aiParams;
    }

    public void setAiParams(AIParams aiParams) {
        this.aiParams = aiParams;
    }

    public static class AIParams {
        @JSONField(name="account")
        private String account;
        @JSONField(name="content")
        private String content;
        @JSONField(name="messages")
        private String messages;
        @JSONField(name="prompt_variables")
        private String promptVariables;
        @JSONField(name="config")
        private String config;
        @JSONField(name="send_original")
        private Boolean sendOriginal;

        public String getAccount() {
            return this.account;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getMessages() {
            return this.messages;
        }

        public void setMessages(String messages) {
            this.messages = messages;
        }

        public String getPromptVariables() {
            return this.promptVariables;
        }

        public void setPromptVariables(String promptVariables) {
            this.promptVariables = promptVariables;
        }

        public String getConfig() {
            return this.config;
        }

        public void setConfig(String config) {
            this.config = config;
        }

        public Boolean getSendOriginal() {
            return this.sendOriginal;
        }

        public void setSendOriginal(Boolean sendOriginal) {
            this.sendOriginal = sendOriginal;
        }
    }

    public static class ThreadMessage {
        @JSONField(name="sender_id")
        private String senderId;
        @JSONField(name="receiver_id")
        private String receiverId;
        @JSONField(name="create_time")
        private Long createTime;
        @JSONField(name="message_server_id")
        private Long messageServerId;
        @JSONField(name="message_client_id")
        private String messageClientId;

        public String getSenderId() {
            return this.senderId;
        }

        public void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public String getReceiverId() {
            return this.receiverId;
        }

        public void setReceiverId(String receiverId) {
            this.receiverId = receiverId;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public Long getMessageServerId() {
            return this.messageServerId;
        }

        public void setMessageServerId(Long messageServerId) {
            this.messageServerId = messageServerId;
        }

        public String getMessageClientId() {
            return this.messageClientId;
        }

        public void setMessageClientId(String messageClientId) {
            this.messageClientId = messageClientId;
        }
    }

    public static class ThreadConfig {
        @JSONField(name="thread_root")
        private ThreadMessage threadRoot;
        @JSONField(name="thread_reply")
        private ThreadMessage threadReply;

        public ThreadMessage getThreadRoot() {
            return this.threadRoot;
        }

        public void setThreadRoot(ThreadMessage threadRoot) {
            this.threadRoot = threadRoot;
        }

        public ThreadMessage getThreadReply() {
            return this.threadReply;
        }

        public void setThreadReply(ThreadMessage threadReply) {
            this.threadReply = threadReply;
        }
    }

    public static class RobotConfig {
        @JSONField(name="robot_account_id")
        private String robotAccountId;
        @JSONField(name="robot_topic")
        private String robotTopic;
        @JSONField(name="robot_function")
        private String robotFunction;
        @JSONField(name="robot_custom_content")
        private String robotCustomContent;

        public String getRobotAccountId() {
            return this.robotAccountId;
        }

        public void setRobotAccountId(String robotAccountId) {
            this.robotAccountId = robotAccountId;
        }

        public String getRobotTopic() {
            return this.robotTopic;
        }

        public void setRobotTopic(String robotTopic) {
            this.robotTopic = robotTopic;
        }

        public String getRobotFunction() {
            return this.robotFunction;
        }

        public void setRobotFunction(String robotFunction) {
            this.robotFunction = robotFunction;
        }

        public String getRobotCustomContent() {
            return this.robotCustomContent;
        }

        public void setRobotCustomContent(String robotCustomContent) {
            this.robotCustomContent = robotCustomContent;
        }
    }

    public static class SuperTeamOption {
        @JSONField(name="ignore_chat_banned")
        private Boolean ignoreChatBanned;
        @JSONField(name="ignore_member_chat_banned")
        private Boolean ignoreMemberChatBanned;
        @JSONField(name="check_team_member_valid")
        private Boolean checkTeamMemberValid;

        public Boolean getIgnoreChatBanned() {
            return this.ignoreChatBanned;
        }

        public void setIgnoreChatBanned(Boolean ignoreChatBanned) {
            this.ignoreChatBanned = ignoreChatBanned;
        }

        public Boolean getIgnoreMemberChatBanned() {
            return this.ignoreMemberChatBanned;
        }

        public void setIgnoreMemberChatBanned(Boolean ignoreMemberChatBanned) {
            this.ignoreMemberChatBanned = ignoreMemberChatBanned;
        }

        public Boolean getCheckTeamMemberValid() {
            return this.checkTeamMemberValid;
        }

        public void setCheckTeamMemberValid(Boolean checkTeamMemberValid) {
            this.checkTeamMemberValid = checkTeamMemberValid;
        }
    }

    public static class TeamOption {
        @JSONField(name="mark_as_read")
        private Boolean markAsRead;
        @JSONField(name="ignore_chat_banned")
        private Boolean ignoreChatBanned;
        @JSONField(name="ignore_member_chat_banned")
        private Boolean ignoreMemberChatBanned;
        @JSONField(name="check_team_member_valid")
        private Boolean checkTeamMemberValid;

        public Boolean getMarkAsRead() {
            return this.markAsRead;
        }

        public void setMarkAsRead(Boolean markAsRead) {
            this.markAsRead = markAsRead;
        }

        public Boolean getIgnoreChatBanned() {
            return this.ignoreChatBanned;
        }

        public void setIgnoreChatBanned(Boolean ignoreChatBanned) {
            this.ignoreChatBanned = ignoreChatBanned;
        }

        public Boolean getIgnoreMemberChatBanned() {
            return this.ignoreMemberChatBanned;
        }

        public void setIgnoreMemberChatBanned(Boolean ignoreMemberChatBanned) {
            this.ignoreMemberChatBanned = ignoreMemberChatBanned;
        }

        public Boolean getCheckTeamMemberValid() {
            return this.checkTeamMemberValid;
        }

        public void setCheckTeamMemberValid(Boolean checkTeamMemberValid) {
            this.checkTeamMemberValid = checkTeamMemberValid;
        }
    }

    public static class P2POption {
        @JSONField(name="check_friend")
        private Boolean checkFriend;

        public Boolean getCheckFriend() {
            return this.checkFriend;
        }

        public void setCheckFriend(Boolean checkFriend) {
            this.checkFriend = checkFriend;
        }
    }

    public static class AntispamConfig {
        @JSONField(name="antispam_enabled")
        private Boolean antispamEnabled;
        @JSONField(name="antispam_business_id")
        private String antispamBusinessId;
        @JSONField(name="antispam_extension")
        private String antispamExtension;
        @JSONField(name="antispam_cheating")
        private String antispamCheating;
        @JSONField(name="antispam_custom_message_enabled")
        private Boolean antispamCustomMessageEnabled;
        @JSONField(name="antispam_custom_message")
        private String antispamCustomMessage;

        public Boolean getAntispamEnabled() {
            return this.antispamEnabled;
        }

        public void setAntispamEnabled(Boolean antispamEnabled) {
            this.antispamEnabled = antispamEnabled;
        }

        public String getAntispamBusinessId() {
            return this.antispamBusinessId;
        }

        public void setAntispamBusinessId(String antispamBusinessId) {
            this.antispamBusinessId = antispamBusinessId;
        }

        public String getAntispamExtension() {
            return this.antispamExtension;
        }

        public void setAntispamExtension(String antispamExtension) {
            this.antispamExtension = antispamExtension;
        }

        public String getAntispamCheating() {
            return this.antispamCheating;
        }

        public void setAntispamCheating(String antispamCheating) {
            this.antispamCheating = antispamCheating;
        }

        public Boolean getAntispamCustomMessageEnabled() {
            return this.antispamCustomMessageEnabled;
        }

        public void setAntispamCustomMessageEnabled(Boolean antispamCustomMessageEnabled) {
            this.antispamCustomMessageEnabled = antispamCustomMessageEnabled;
        }

        public String getAntispamCustomMessage() {
            return this.antispamCustomMessage;
        }

        public void setAntispamCustomMessage(String antispamCustomMessage) {
            this.antispamCustomMessage = antispamCustomMessage;
        }
    }

    public static class PushConfig {
        @JSONField(name="push_enabled")
        private Boolean pushEnabled;
        @JSONField(name="push_nick_enabled")
        private Boolean pushNickEnabled;
        @JSONField(name="push_content")
        private String pushContent;
        @JSONField(name="push_payload")
        private String pushPayload;
        @JSONField(name="push_forcepush_all")
        private Boolean pushForcepushAll;
        @JSONField(name="push_forcepush_ids")
        private List<String> pushForcepushIds;
        @JSONField(name="push_forcepush_content")
        private String pushForcepushContent;
        @JSONField(name="push_forcepush_enable")
        private Boolean pushForcepushEnable;

        public Boolean getPushEnabled() {
            return this.pushEnabled;
        }

        public void setPushEnabled(Boolean pushEnabled) {
            this.pushEnabled = pushEnabled;
        }

        public Boolean getPushNickEnabled() {
            return this.pushNickEnabled;
        }

        public void setPushNickEnabled(Boolean pushNickEnabled) {
            this.pushNickEnabled = pushNickEnabled;
        }

        public String getPushContent() {
            return this.pushContent;
        }

        public void setPushContent(String pushContent) {
            this.pushContent = pushContent;
        }

        public String getPushPayload() {
            return this.pushPayload;
        }

        public void setPushPayload(String pushPayload) {
            this.pushPayload = pushPayload;
        }

        public Boolean getPushForcepushAll() {
            return this.pushForcepushAll;
        }

        public void setPushForcepushAll(Boolean pushForcepushAll) {
            this.pushForcepushAll = pushForcepushAll;
        }

        public List<String> getPushForcepushIds() {
            return this.pushForcepushIds;
        }

        public void setPushForcepushIds(List<String> pushForcepushIds) {
            this.pushForcepushIds = pushForcepushIds;
        }

        public String getPushForcepushContent() {
            return this.pushForcepushContent;
        }

        public void setPushForcepushContent(String pushForcepushContent) {
            this.pushForcepushContent = pushForcepushContent;
        }

        public Boolean getPushForcepushEnable() {
            return this.pushForcepushEnable;
        }

        public void setPushForcepushEnable(Boolean pushForcepushEnable) {
            this.pushForcepushEnable = pushForcepushEnable;
        }
    }

    public static class RouteConfig {
        @JSONField(name="route_enabled")
        private Boolean routeEnabled;
        @JSONField(name="route_environment")
        private String routeEnvironment;

        public Boolean getRouteEnabled() {
            return this.routeEnabled;
        }

        public void setRouteEnabled(Boolean routeEnabled) {
            this.routeEnabled = routeEnabled;
        }

        public String getRouteEnvironment() {
            return this.routeEnvironment;
        }

        public void setRouteEnvironment(String routeEnvironment) {
            this.routeEnvironment = routeEnvironment;
        }
    }

    public static class TargetOption {
        @JSONField(name="receiver_account_ids")
        private List<String> receiverAccountIds;
        @JSONField(name="inclusive")
        private Boolean inclusive;
        @JSONField(name="check_team_member_valid")
        private Boolean checkTeamMemberValid;
        @JSONField(name="visible_to_new_member")
        private Boolean visibleToNewMember;

        public List<String> getReceiverAccountIds() {
            return this.receiverAccountIds;
        }

        public void setReceiverAccountIds(List<String> receiverAccountIds) {
            this.receiverAccountIds = receiverAccountIds;
        }

        public Boolean getInclusive() {
            return this.inclusive;
        }

        public void setInclusive(Boolean inclusive) {
            this.inclusive = inclusive;
        }

        public Boolean getCheckTeamMemberValid() {
            return this.checkTeamMemberValid;
        }

        public void setCheckTeamMemberValid(Boolean checkTeamMemberValid) {
            this.checkTeamMemberValid = checkTeamMemberValid;
        }

        public Boolean getVisibleToNewMember() {
            return this.visibleToNewMember;
        }

        public void setVisibleToNewMember(Boolean visibleToNewMember) {
            this.visibleToNewMember = visibleToNewMember;
        }
    }

    public static class MessageConfig {
        @JSONField(name="unread_enabled")
        private Boolean unreadEnabled;
        @JSONField(name="mutil_sync_enabled")
        private Boolean mutilSyncEnabled;
        @JSONField(name="offline_enabled")
        private Boolean offlineEnabled;
        @JSONField(name="history_enabled")
        private Boolean historyEnabled;
        @JSONField(name="roaming_enabled")
        private Boolean roamingEnabled;
        @JSONField(name="conversation_update_enabled")
        private Boolean conversationUpdateEnabled;

        public Boolean getUnreadEnabled() {
            return this.unreadEnabled;
        }

        public void setUnreadEnabled(Boolean unreadEnabled) {
            this.unreadEnabled = unreadEnabled;
        }

        public Boolean getMutilSyncEnabled() {
            return this.mutilSyncEnabled;
        }

        public void setMutilSyncEnabled(Boolean mutilSyncEnabled) {
            this.mutilSyncEnabled = mutilSyncEnabled;
        }

        public Boolean getOfflineEnabled() {
            return this.offlineEnabled;
        }

        public void setOfflineEnabled(Boolean offlineEnabled) {
            this.offlineEnabled = offlineEnabled;
        }

        public Boolean getHistoryEnabled() {
            return this.historyEnabled;
        }

        public void setHistoryEnabled(Boolean historyEnabled) {
            this.historyEnabled = historyEnabled;
        }

        public Boolean getRoamingEnabled() {
            return this.roamingEnabled;
        }

        public void setRoamingEnabled(Boolean roamingEnabled) {
            this.roamingEnabled = roamingEnabled;
        }

        public Boolean getConversationUpdateEnabled() {
            return this.conversationUpdateEnabled;
        }

        public void setConversationUpdateEnabled(Boolean conversationUpdateEnabled) {
            this.conversationUpdateEnabled = conversationUpdateEnabled;
        }
    }

    public static class MessageBody {
        @JSONField(name="message_type")
        private Integer messageType;
        @JSONField(name="sub_type")
        private Integer subType;
        @JSONField(name="text")
        private String text;
        @JSONField(name="attachment")
        private Map<?, ?> attachment;
        @JSONField(name="message_client_id")
        private String messageClientId;

        public Integer getMessageType() {
            return this.messageType;
        }

        public void setMessageType(Integer messageType) {
            this.messageType = messageType;
        }

        public Integer getSubType() {
            return this.subType;
        }

        public void setSubType(Integer subType) {
            this.subType = subType;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Map<?, ?> getAttachment() {
            return this.attachment;
        }

        public void setAttachment(Map<?, ?> attachment) {
            this.attachment = attachment;
        }

        public String getMessageClientId() {
            return this.messageClientId;
        }

        public void setMessageClientId(String messageClientId) {
            this.messageClientId = messageClientId;
        }
    }
}

