/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.friend;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.friend.IFriendV2Service;
import com.netease.nim.server.sdk.im.v2.friend.request.AddFriendRequestV2;
import com.netease.nim.server.sdk.im.v2.friend.request.DeleteFriendRequestV2;
import com.netease.nim.server.sdk.im.v2.friend.request.GetFriendRequestV2;
import com.netease.nim.server.sdk.im.v2.friend.request.HandleFriendAdditionRequestV2;
import com.netease.nim.server.sdk.im.v2.friend.request.ListFriendsRequestV2;
import com.netease.nim.server.sdk.im.v2.friend.request.UpdateFriendRequestV2;
import com.netease.nim.server.sdk.im.v2.friend.response.AddFriendResponseV2;
import com.netease.nim.server.sdk.im.v2.friend.response.DeleteFriendResponseV2;
import com.netease.nim.server.sdk.im.v2.friend.response.GetFriendResponseV2;
import com.netease.nim.server.sdk.im.v2.friend.response.HandleFriendAdditionResponseV2;
import com.netease.nim.server.sdk.im.v2.friend.response.ListFriendsResponseV2;
import com.netease.nim.server.sdk.im.v2.friend.response.UpdateFriendResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class FriendV2Service
implements IFriendV2Service {
    private final YunxinApiHttpClient httpClient;

    public FriendV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<AddFriendResponseV2> addFriend(AddFriendRequestV2 request) throws YunxinSdkException {
        JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        HashMap<String, String> queryParams = null;
        Integer type = request.getType();
        if (type != null) {
            queryParams = new HashMap<String, String>();
            queryParams.put("type", type.toString());
            data.remove((Object)"type");
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2.1/friends", "/im/v2.1/friends", queryParams, data.toString());
        return ResultUtils.convert(apiResponse, AddFriendResponseV2.class);
    }

    @Override
    public Result<DeleteFriendResponseV2> deleteFriend(DeleteFriendRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/friends/{account_id}".replace("{account_id}", request.getAccountId());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("friend_account_id", request.getFriendAccountId());
        if (request.getDeleteAlias() != null) {
            queryParams.put("delete_alias", request.getDeleteAlias().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/friends/{account_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, DeleteFriendResponseV2.class);
    }

    @Override
    public Result<UpdateFriendResponseV2> updateFriend(UpdateFriendRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2.1/friends/{account_id}".replace("{account_id}", request.getAccountId());
        JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        data.remove((Object)"account_id");
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2.1/friends/{account_id}", path, null, data.toString());
        return ResultUtils.convert(apiResponse, UpdateFriendResponseV2.class);
    }

    @Override
    public Result<HandleFriendAdditionResponseV2> handleFriendAddition(HandleFriendAdditionRequestV2 request) throws YunxinSdkException {
        JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        HashMap<String, String> queryParams = null;
        Integer type = request.getType();
        if (type != null) {
            queryParams = new HashMap<String, String>();
            queryParams.put("type", type.toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2.1/friends/actions/handle_friend_addition", "/im/v2.1/friends/actions/handle_friend_addition", queryParams, data.toString());
        return ResultUtils.convert(apiResponse, HandleFriendAdditionResponseV2.class);
    }

    @Override
    public Result<GetFriendResponseV2> getFriend(GetFriendRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2.1/friends/{account_id}".replace("{account_id}", request.getAccountId());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("friend_account_id", request.getFriendAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/friends/{account_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, GetFriendResponseV2.class);
    }

    @Override
    public Result<ListFriendsResponseV2> listFriends(ListFriendsRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", request.getAccountId());
        if (request.getPageToken() != null) {
            queryParams.put("page_token", request.getPageToken());
        }
        if (request.getLimit() != null) {
            queryParams.put("limit", request.getLimit().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/friends", "/im/v2.1/friends", queryParams, null);
        return ResultUtils.convert(apiResponse, ListFriendsResponseV2.class);
    }
}

