/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.conversation_group;

import com.alibaba.fastjson2.JSON;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.conversation_group.IConversationGroupV2Service;
import com.netease.nim.server.sdk.im.v2.conversation_group.request.BatchGetConversationGroupsRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.request.CreateConversationGroupRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.request.DeleteConversationGroupRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.request.GetConversationGroupRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.request.ListAllConversationGroupsRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.request.UpdateConversationGroupRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.response.BatchGetConversationGroupsResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.response.CreateConversationGroupResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.response.DeleteConversationGroupResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.response.GetConversationGroupResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.response.ListAllConversationGroupsResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation_group.response.UpdateConversationGroupResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ConversationGroupV2Service
implements IConversationGroupV2Service {
    private final YunxinApiHttpClient httpClient;

    public ConversationGroupV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateConversationGroupResponseV2> createConversationGroup(CreateConversationGroupRequestV2 request) throws YunxinSdkException {
        String requestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/conversation_groups", "/im/v2/conversation_groups", null, requestBody);
        return ResultUtils.convert(apiResponse, CreateConversationGroupResponseV2.class);
    }

    @Override
    public Result<UpdateConversationGroupResponseV2> updateConversationGroup(UpdateConversationGroupRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/conversation_groups/{group_id}".replace("{group_id}", String.valueOf(request.getGroupId()));
        String requestBody = JSON.toJSONString((Object)request);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/conversation_groups/{group_id}", path, null, requestBody);
        return ResultUtils.convert(apiResponse, UpdateConversationGroupResponseV2.class);
    }

    @Override
    public Result<DeleteConversationGroupResponseV2> deleteConversationGroup(DeleteConversationGroupRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/conversation_groups/{group_id}".replace("{group_id}", String.valueOf(request.getGroupId()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/conversation_groups/{group_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, DeleteConversationGroupResponseV2.class);
    }

    @Override
    public Result<GetConversationGroupResponseV2> getConversationGroup(GetConversationGroupRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/conversation_groups/{group_id}".replace("{group_id}", String.valueOf(request.getGroupId()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/conversation_groups/{group_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, GetConversationGroupResponseV2.class);
    }

    @Override
    public Result<BatchGetConversationGroupsResponseV2> batchGetConversationGroups(BatchGetConversationGroupsRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", request.getAccountId());
        System.out.println(request.getGroupIds().toString());
        List<Long> groupIds = request.getGroupIds();
        String collect = groupIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        queryParams.put("group_ids", String.join((CharSequence)",", collect));
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/conversation_groups/actions/group_ids", "/im/v2/conversation_groups/actions/group_ids", queryParams, null);
        return ResultUtils.convert(apiResponse, BatchGetConversationGroupsResponseV2.class);
    }

    @Override
    public Result<ListAllConversationGroupsResponseV2> listAllConversationGroups(ListAllConversationGroupsRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", request.getAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/conversation_groups", "/im/v2/conversation_groups", queryParams, null);
        return ResultUtils.convert(apiResponse, ListAllConversationGroupsResponseV2.class);
    }
}

