/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.conversation;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.conversation.IConversationV2Service;
import com.netease.nim.server.sdk.im.v2.conversation.request.BatchDeleteConversationsRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation.request.BatchGetConversationsRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation.request.CreateConversationRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation.request.DeleteConversationRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation.request.GetConversationRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation.request.ListConversationsRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation.request.StickTopConversationRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation.request.UpdateConversationRequestV2;
import com.netease.nim.server.sdk.im.v2.conversation.response.BatchDeleteConversationsResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation.response.BatchGetConversationsResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation.response.CreateConversationResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation.response.DeleteConversationResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation.response.GetConversationResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation.response.ListConversationsResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation.response.StickTopConversationResponseV2;
import com.netease.nim.server.sdk.im.v2.conversation.response.UpdateConversationResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;
import java.util.List;

public class ConversationV2Service
implements IConversationV2Service {
    private final YunxinApiHttpClient httpClient;

    public ConversationV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<CreateConversationResponseV2> createConversation(CreateConversationRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2.1/conversations", "/im/v2.1/conversations", null, requestBody);
        return ResultUtils.convert(apiResponse, CreateConversationResponseV2.class);
    }

    @Override
    public Result<UpdateConversationResponseV2> updateConversation(UpdateConversationRequestV2 request) throws YunxinSdkException {
        String conversationId = request.getConversationId();
        if (conversationId == null || conversationId.isEmpty()) {
            throw new IllegalArgumentException("Conversation ID cannot be null or empty");
        }
        String path = "/im/v2/conversations/{conversation_id}".replace("{conversation_id}", conversationId);
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/conversations/{conversation_id}", path, null, requestBody);
        return ResultUtils.convert(apiResponse, UpdateConversationResponseV2.class);
    }

    @Override
    public Result<DeleteConversationResponseV2> deleteConversation(DeleteConversationRequestV2 request) throws YunxinSdkException {
        String conversationId = request.getConversationId();
        if (conversationId == null || conversationId.isEmpty()) {
            throw new IllegalArgumentException("Conversation ID cannot be null or empty");
        }
        String path = "/im/v2/conversations/{conversation_id}".replace("{conversation_id}", conversationId);
        HashMap<String, String> queryParams = null;
        if (request.getClearMessage() != null) {
            queryParams = new HashMap<String, String>();
            queryParams.put("clear_message", request.getClearMessage().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/conversations/{conversation_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, DeleteConversationResponseV2.class);
    }

    @Override
    public Result<BatchDeleteConversationsResponseV2> batchDeleteConversations(BatchDeleteConversationsRequestV2 request) throws YunxinSdkException {
        List<String> conversationIds = request.getConversationIds();
        if (conversationIds == null || conversationIds.isEmpty()) {
            throw new IllegalArgumentException("Conversation IDs list cannot be null or empty");
        }
        String conversationIdsParam = String.join((CharSequence)",", conversationIds);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("conversation_ids", conversationIdsParam);
        if (request.getClearMessage() != null) {
            queryParams.put("clear_message", request.getClearMessage().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/conversations/actions/conversation_ids", "/im/v2/conversations/actions/conversation_ids", queryParams, null);
        return ResultUtils.convert(apiResponse, BatchDeleteConversationsResponseV2.class);
    }

    @Override
    public Result<GetConversationResponseV2> getConversation(GetConversationRequestV2 request) throws YunxinSdkException {
        String conversationId = request.getConversationId();
        if (conversationId == null || conversationId.isEmpty()) {
            throw new IllegalArgumentException("Conversation ID cannot be null or empty");
        }
        String path = "/im/v2.1/conversations/{conversation_id}".replace("{conversation_id}", conversationId);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/conversations/{conversation_id}", path, null, null);
        return ResultUtils.convert(apiResponse, GetConversationResponseV2.class);
    }

    @Override
    public Result<BatchGetConversationsResponseV2> batchGetConversations(BatchGetConversationsRequestV2 request) throws YunxinSdkException {
        List<String> conversationIds = request.getConversationIds();
        if (conversationIds == null || conversationIds.isEmpty()) {
            throw new IllegalArgumentException("Conversation IDs list cannot be null or empty");
        }
        String conversationIdsParam = String.join((CharSequence)",", conversationIds);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("conversation_ids", conversationIdsParam);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/conversations/actions/conversation_ids", "/im/v2.1/conversations/actions/conversation_ids", queryParams, null);
        return ResultUtils.convert(apiResponse, BatchGetConversationsResponseV2.class);
    }

    @Override
    public Result<ListConversationsResponseV2> listConversations(ListConversationsRequestV2 request) throws YunxinSdkException {
        String accountId = request.getAccountId();
        if (accountId == null || accountId.isEmpty()) {
            throw new IllegalArgumentException("Account ID cannot be null or empty");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", accountId);
        if (request.getPageToken() != null && !request.getPageToken().isEmpty()) {
            queryParams.put("page_token", request.getPageToken());
        }
        if (request.getLimit() != null) {
            queryParams.put("limit", request.getLimit().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/conversations", "/im/v2.1/conversations", queryParams, null);
        return ResultUtils.convert(apiResponse, ListConversationsResponseV2.class);
    }

    @Override
    public Result<StickTopConversationResponseV2> stickTopConversation(StickTopConversationRequestV2 request) throws YunxinSdkException {
        String conversationId = request.getConversationId();
        if (conversationId == null || conversationId.isEmpty()) {
            throw new IllegalArgumentException("Conversation ID cannot be null or empty");
        }
        Integer topType = request.getTopType();
        if (topType == null || topType != 0 && topType != 1) {
            throw new IllegalArgumentException("Top type must be 1 (pin) or 0 (unpin)");
        }
        String path = "/im/v2/conversations/{conversation_id}/actions/stick_top_conversation".replace("{conversation_id}", conversationId);
        HashMap<String, Integer> requestBodyMap = new HashMap<String, Integer>();
        requestBodyMap.put("top_type", topType);
        String requestBody = JSONObject.toJSONString(requestBodyMap, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/conversations/{conversation_id}/actions/stick_top_conversation", path, null, requestBody);
        return ResultUtils.convert(apiResponse, StickTopConversationResponseV2.class);
    }
}

