/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.chatroom_queue;

import com.alibaba.fastjson2.JSONObject;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.IChatroomQueueV2Service;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.request.DeleteChatroomQueueRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.request.InitializeChatroomQueueRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.request.PollChatroomQueueElementRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.request.QueryChatroomQueueElementsRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.request.UpdateChatroomQueueRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.response.DeleteChatroomQueueResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.response.InitializeChatroomQueueResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.response.PollChatroomQueueElementResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.response.QueryChatroomQueueElementsResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_queue.response.UpdateChatroomQueueResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.ArrayList;

public class ChatroomQueueV2Service
implements IChatroomQueueV2Service {
    private final YunxinApiHttpClient httpClient;

    public ChatroomQueueV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<InitializeChatroomQueueResponseV2> initializeChatroomQueue(InitializeChatroomQueueRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        JSONObject requestBody = new JSONObject();
        if (request.getQueueSizeLimit() != null) {
            requestBody.put((Object)"queue_size_limit", (Object)request.getQueueSizeLimit());
        }
        if (request.getRouteConfig() != null) {
            JSONObject routeConfig = new JSONObject();
            if (request.getRouteConfig().getRouteEnabled() != null) {
                routeConfig.put((Object)"route_enabled", (Object)request.getRouteConfig().getRouteEnabled());
            }
            if (request.getRouteConfig().getRouteEnvironment() != null) {
                routeConfig.put((Object)"route_environment", (Object)request.getRouteConfig().getRouteEnvironment());
            }
            if (!routeConfig.isEmpty()) {
                requestBody.put((Object)"route_config", (Object)routeConfig);
            }
        }
        String path = "/im/v2/room_queues/{room_id}".replace("{room_id}", request.getRoomId().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/room_queues/{room_id}", path, null, requestBody.isEmpty() ? "{}" : requestBody.toString());
        return ResultUtils.convert(apiResponse, InitializeChatroomQueueResponseV2.class);
    }

    @Override
    public Result<QueryChatroomQueueElementsResponseV2> queryChatroomQueueElements(QueryChatroomQueueElementsRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        JSONObject requestBody = new JSONObject();
        if (request.getElementKeyList() != null && !request.getElementKeyList().isEmpty()) {
            requestBody.put((Object)"element_key_list", request.getElementKeyList());
        }
        if (request.getRouteConfig() != null) {
            JSONObject routeConfig = new JSONObject();
            if (request.getRouteConfig().getRouteEnabled() != null) {
                routeConfig.put((Object)"route_enabled", (Object)request.getRouteConfig().getRouteEnabled());
            }
            if (request.getRouteConfig().getRouteEnvironment() != null) {
                routeConfig.put((Object)"route_environment", (Object)request.getRouteConfig().getRouteEnvironment());
            }
            if (!routeConfig.isEmpty()) {
                requestBody.put((Object)"route_config", (Object)routeConfig);
            }
        }
        String path = "/im/v2/room_queues/{room_id}/actions/query".replace("{room_id}", request.getRoomId().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/room_queues/{room_id}/actions/query", path, null, requestBody.isEmpty() ? "{}" : requestBody.toString());
        return ResultUtils.convert(apiResponse, QueryChatroomQueueElementsResponseV2.class);
    }

    @Override
    public Result<UpdateChatroomQueueResponseV2> updateChatroomQueue(UpdateChatroomQueueRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getOperatorAccountId() == null || request.getOperatorAccountId().trim().isEmpty()) {
            throw new IllegalArgumentException("Operator account ID cannot be null or empty");
        }
        if (request.getElementList() == null || request.getElementList().isEmpty()) {
            throw new IllegalArgumentException("Element list cannot be null or empty");
        }
        for (UpdateChatroomQueueRequestV2.QueueElement element : request.getElementList()) {
            if (element.getElementKey() == null || element.getElementKey().trim().isEmpty()) {
                throw new IllegalArgumentException("Element key cannot be null or empty");
            }
            if (element.getElementValue() == null || element.getElementValue().trim().isEmpty()) {
                throw new IllegalArgumentException("Element value cannot be null or empty");
            }
            if (element.getElementAddPolicy() == null || element.getElementAddPolicy() >= 0 && element.getElementAddPolicy() <= 2) continue;
            throw new IllegalArgumentException("Element add policy must be 0, 1, or 2");
        }
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"operator_account_id", (Object)request.getOperatorAccountId());
        ArrayList<JSONObject> elementList = new ArrayList<JSONObject>();
        for (UpdateChatroomQueueRequestV2.QueueElement element : request.getElementList()) {
            JSONObject elementJson = new JSONObject();
            elementJson.put((Object)"element_key", (Object)element.getElementKey());
            elementJson.put((Object)"element_value", (Object)element.getElementValue());
            if (element.getElementAccountId() != null) {
                elementJson.put((Object)"element_account_id", (Object)element.getElementAccountId());
            }
            if (element.getElementTransient() != null) {
                elementJson.put((Object)"element_transient", (Object)element.getElementTransient());
            }
            if (element.getElementAddPolicy() != null) {
                elementJson.put((Object)"element_add_policy", (Object)element.getElementAddPolicy());
            }
            elementList.add(elementJson);
        }
        requestBody.put((Object)"element_list", elementList);
        if (request.getNotificationConfig() != null) {
            JSONObject notificationConfig = new JSONObject();
            if (request.getNotificationConfig().getNotificationEnabled() != null) {
                notificationConfig.put((Object)"notification_enabled", (Object)request.getNotificationConfig().getNotificationEnabled());
            }
            if (request.getNotificationConfig().getNotificationExtension() != null) {
                notificationConfig.put((Object)"notification_extension", (Object)request.getNotificationConfig().getNotificationExtension());
            }
            if (request.getNotificationConfig().getHighPriority() != null) {
                notificationConfig.put((Object)"high_priority", (Object)request.getNotificationConfig().getHighPriority());
            }
            if (request.getNotificationConfig().getHighPriorityPolicy() != null) {
                notificationConfig.put((Object)"high_priority_policy", (Object)request.getNotificationConfig().getHighPriorityPolicy());
            }
            if (!notificationConfig.isEmpty()) {
                requestBody.put((Object)"notification_config", (Object)notificationConfig);
            }
        }
        if (request.getRouteConfig() != null) {
            JSONObject routeConfig = new JSONObject();
            if (request.getRouteConfig().getRouteEnabled() != null) {
                routeConfig.put((Object)"route_enabled", (Object)request.getRouteConfig().getRouteEnabled());
            }
            if (request.getRouteConfig().getRouteEnvironment() != null) {
                routeConfig.put((Object)"route_environment", (Object)request.getRouteConfig().getRouteEnvironment());
            }
            if (!routeConfig.isEmpty()) {
                requestBody.put((Object)"route_config", (Object)routeConfig);
            }
        }
        String path = "/im/v2/room_queues/{room_id}".replace("{room_id}", request.getRoomId().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/room_queues/{room_id}", path, null, requestBody.toString());
        return ResultUtils.convert(apiResponse, UpdateChatroomQueueResponseV2.class);
    }

    @Override
    public Result<DeleteChatroomQueueResponseV2> deleteChatroomQueue(DeleteChatroomQueueRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        JSONObject requestBody = new JSONObject();
        if (request.getNotificationConfig() != null) {
            JSONObject notificationConfig = new JSONObject();
            if (request.getNotificationConfig().getNotificationEnabled() != null) {
                notificationConfig.put((Object)"notification_enabled", (Object)request.getNotificationConfig().getNotificationEnabled());
            }
            if (request.getNotificationConfig().getNotificationExtension() != null) {
                notificationConfig.put((Object)"notification_extension", (Object)request.getNotificationConfig().getNotificationExtension());
            }
            if (request.getNotificationConfig().getHighPriority() != null) {
                notificationConfig.put((Object)"high_priority", (Object)request.getNotificationConfig().getHighPriority());
            }
            if (request.getNotificationConfig().getHighPriorityPolicy() != null) {
                notificationConfig.put((Object)"high_priority_policy", (Object)request.getNotificationConfig().getHighPriorityPolicy());
            }
            if (!notificationConfig.isEmpty()) {
                requestBody.put((Object)"notification_config", (Object)notificationConfig);
            }
        }
        if (request.getRouteConfig() != null) {
            JSONObject routeConfig = new JSONObject();
            if (request.getRouteConfig().getRouteEnabled() != null) {
                routeConfig.put((Object)"route_enabled", (Object)request.getRouteConfig().getRouteEnabled());
            }
            if (request.getRouteConfig().getRouteEnvironment() != null) {
                routeConfig.put((Object)"route_environment", (Object)request.getRouteConfig().getRouteEnvironment());
            }
            if (!routeConfig.isEmpty()) {
                requestBody.put((Object)"route_config", (Object)routeConfig);
            }
        }
        String path = "/im/v2/room_queues/{room_id}".replace("{room_id}", request.getRoomId().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/room_queues/{room_id}", path, null, requestBody.isEmpty() ? null : requestBody.toString());
        return ResultUtils.convert(apiResponse, DeleteChatroomQueueResponseV2.class);
    }

    @Override
    public Result<PollChatroomQueueElementResponseV2> pollChatroomQueueElement(PollChatroomQueueElementRequestV2 request) throws YunxinSdkException {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        JSONObject requestBody = new JSONObject();
        if (request.getElementKey() != null) {
            requestBody.put((Object)"element_key", (Object)request.getElementKey());
        }
        if (request.getNotificationConfig() != null) {
            JSONObject notificationConfig = new JSONObject();
            if (request.getNotificationConfig().getNotificationEnabled() != null) {
                notificationConfig.put((Object)"notification_enabled", (Object)request.getNotificationConfig().getNotificationEnabled());
            }
            if (request.getNotificationConfig().getNotificationExtension() != null) {
                notificationConfig.put((Object)"notification_extension", (Object)request.getNotificationConfig().getNotificationExtension());
            }
            if (request.getNotificationConfig().getHighPriority() != null) {
                notificationConfig.put((Object)"high_priority", (Object)request.getNotificationConfig().getHighPriority());
            }
            if (request.getNotificationConfig().getHighPriorityPolicy() != null) {
                notificationConfig.put((Object)"high_priority_policy", (Object)request.getNotificationConfig().getHighPriorityPolicy());
            }
            if (!notificationConfig.isEmpty()) {
                requestBody.put((Object)"notification_config", (Object)notificationConfig);
            }
        }
        if (request.getRouteConfig() != null) {
            JSONObject routeConfig = new JSONObject();
            if (request.getRouteConfig().getRouteEnabled() != null) {
                routeConfig.put((Object)"route_enabled", (Object)request.getRouteConfig().getRouteEnabled());
            }
            if (request.getRouteConfig().getRouteEnvironment() != null) {
                routeConfig.put((Object)"route_environment", (Object)request.getRouteConfig().getRouteEnvironment());
            }
            if (!routeConfig.isEmpty()) {
                requestBody.put((Object)"route_config", (Object)routeConfig);
            }
        }
        String path = "/im/v2/room_queues/{room_id}/actions/poll".replace("{room_id}", request.getRoomId().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/room_queues/{room_id}/actions/poll", path, null, requestBody.isEmpty() ? "{}" : requestBody.toString());
        return ResultUtils.convert(apiResponse, PollChatroomQueueElementResponseV2.class);
    }
}

