/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.chatroom_member;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.chatroom_member.IChatroomMemberV2Service;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.AddVirtualMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.BatchQueryChatroomMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.ClearVirtualMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.DeleteVirtualMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.ListTaggedMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.ModifyMemberTagsRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.QueryChatBannedRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.QueryChatroomBlacklistRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.QueryTaggedMembersCountRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.QueryVirtualMembersRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.SetMemberRoleRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.ToggleBlockedRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.ToggleChatBanRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.ToggleTaggedMembersChatBanRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.ToggleTempChatBanRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.request.UpdateOnlineMemberInfoRequestV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.AddVirtualMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.BatchQueryChatroomMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.ClearVirtualMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.DeleteVirtualMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.ListTaggedMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.ModifyMemberTagsResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.QueryChatBannedResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.QueryChatroomBlacklistResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.QueryTaggedMembersCountResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.QueryVirtualMembersResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.SetMemberRoleResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.ToggleBlockedResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.ToggleChatBanResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.ToggleTaggedMembersChatBanResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.ToggleTempChatBanResponseV2;
import com.netease.nim.server.sdk.im.v2.chatroom_member.response.UpdateOnlineMemberInfoResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class ChatroomMemberV2Service
implements IChatroomMemberV2Service {
    private final YunxinApiHttpClient httpClient;

    public ChatroomMemberV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<SetMemberRoleResponseV2> setMemberRole(SetMemberRoleRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getMemberRole() == null) {
            throw new IllegalArgumentException("Member role cannot be null");
        }
        String path = "/im/v2/room_members/{account_id}".replace("{account_id}", request.getAccountId());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/room_members/{account_id}", path, null, requestBody);
        return ResultUtils.convert(apiResponse, SetMemberRoleResponseV2.class);
    }

    @Override
    public Result<UpdateOnlineMemberInfoResponseV2> updateOnlineMemberInfo(UpdateOnlineMemberInfoRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        String path = "/im/v2/room_members/{account_id}".replace("{account_id}", request.getAccountId());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/room_members/{account_id}", path, null, requestBody);
        return ResultUtils.convert(apiResponse, UpdateOnlineMemberInfoResponseV2.class);
    }

    @Override
    public Result<ToggleChatBanResponseV2> toggleChatBan(ToggleChatBanRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getOperatorAccountId() == null || request.getOperatorAccountId().isEmpty()) {
            throw new IllegalArgumentException("Operator account ID cannot be null or empty");
        }
        if (request.getChatBanned() == null) {
            throw new IllegalArgumentException("Chat banned state cannot be null");
        }
        String path = "/im/v2/room_members/{account_id}/actions/chat_banned".replace("{account_id}", request.getAccountId());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/room_members/{account_id}/actions/chat_banned", path, null, requestBody);
        return ResultUtils.convert(apiResponse, ToggleChatBanResponseV2.class);
    }

    @Override
    public Result<ModifyMemberTagsResponseV2> modifyMemberTags(ModifyMemberTagsRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getTags() == null || request.getTags().isEmpty()) {
            throw new IllegalArgumentException("Tags cannot be null or empty");
        }
        String path = "/im/v2/room_members/{account_id}/actions/tags".replace("{account_id}", request.getAccountId());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/room_members/{account_id}/actions/tags", path, null, requestBody);
        return ResultUtils.convert(apiResponse, ModifyMemberTagsResponseV2.class);
    }

    @Override
    public Result<QueryTaggedMembersCountResponseV2> queryTaggedMembersCount(QueryTaggedMembersCountRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getTag() == null || request.getTag().isEmpty()) {
            throw new IllegalArgumentException("Tag cannot be null or empty");
        }
        String path = "/im/v2/room_members/{room_id}/actions/tagged_members_count".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("tag", request.getTag());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/room_members/{room_id}/actions/tagged_members_count", path, queryParams, null);
        return ResultUtils.convert(apiResponse, QueryTaggedMembersCountResponseV2.class);
    }

    @Override
    public Result<ListTaggedMembersResponseV2> listTaggedMembers(ListTaggedMembersRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getTag() == null || request.getTag().isEmpty()) {
            throw new IllegalArgumentException("Tag cannot be null or empty");
        }
        if (request.getOffset() == null) {
            throw new IllegalArgumentException("Offset cannot be null");
        }
        if (request.getLimit() == null) {
            throw new IllegalArgumentException("Limit cannot be null");
        }
        String path = "/im/v2/room_members/{room_id}/actions/list_tag_members".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("tag", request.getTag());
        queryParams.put("offset", request.getOffset().toString());
        queryParams.put("limit", request.getLimit().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/room_members/{room_id}/actions/list_tag_members", path, queryParams, null);
        return ResultUtils.convert(apiResponse, ListTaggedMembersResponseV2.class);
    }

    @Override
    public Result<ToggleTempChatBanResponseV2> toggleTempChatBan(ToggleTempChatBanRequestV2 request) throws YunxinSdkException {
        if (request.getAccountId() == null || request.getAccountId().isEmpty()) {
            throw new IllegalArgumentException("Account ID cannot be null or empty");
        }
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getOperatorAccountId() == null || request.getOperatorAccountId().isEmpty()) {
            throw new IllegalArgumentException("Operator account ID cannot be null or empty");
        }
        if (request.getChatBanned() == null) {
            throw new IllegalArgumentException("Chat banned state cannot be null");
        }
        if (request.getAccountId().equals(request.getOperatorAccountId())) {
            throw new IllegalArgumentException("Cannot temporarily ban/unban yourself");
        }
        if (Boolean.TRUE.equals(request.getChatBanned()) && request.getChatBannedDuration() == null) {
            throw new IllegalArgumentException("Chat banned duration is required when banning a member");
        }
        String path = "/im/v2/room_members/{account_id}/actions/temp_chat_banned".replace("{account_id}", request.getAccountId());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/room_members/{account_id}/actions/temp_chat_banned", path, null, requestBody);
        return ResultUtils.convert(apiResponse, ToggleTempChatBanResponseV2.class);
    }

    @Override
    public Result<ToggleBlockedResponseV2> toggleBlocked(ToggleBlockedRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getOperatorAccountId() == null || request.getOperatorAccountId().isEmpty()) {
            throw new IllegalArgumentException("Operator account ID cannot be null or empty");
        }
        if (request.getBlocked() == null) {
            throw new IllegalArgumentException("Blocked state cannot be null");
        }
        String path = "/im/v2/room_members/{account_id}/actions/blocked".replace("{account_id}", request.getAccountId());
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/room_members/{account_id}/actions/blocked", path, null, requestBody);
        return ResultUtils.convert(apiResponse, ToggleBlockedResponseV2.class);
    }

    @Override
    public Result<QueryChatroomBlacklistResponseV2> queryChatroomBlacklist(QueryChatroomBlacklistRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        String path = "/im/v2.1/room_members/{room_id}/actions/blocked".replace("{room_id}", request.getRoomId().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/room_members/{room_id}/actions/blocked", path, null, null);
        return ResultUtils.convert(apiResponse, QueryChatroomBlacklistResponseV2.class);
    }

    @Override
    public Result<ToggleTaggedMembersChatBanResponseV2> toggleTaggedMembersChatBan(ToggleTaggedMembersChatBanRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getOperatorAccountId() == null || request.getOperatorAccountId().isEmpty()) {
            throw new IllegalArgumentException("Operator account ID cannot be null or empty");
        }
        if (request.getTargetTag() == null || request.getTargetTag().isEmpty()) {
            throw new IllegalArgumentException("Target tag cannot be null or empty");
        }
        if (request.getChatBanned() == null) {
            throw new IllegalArgumentException("Chat banned state cannot be null");
        }
        if (Boolean.TRUE.equals(request.getChatBanned()) && request.getChatBannedDuration() == null) {
            throw new IllegalArgumentException("Chat banned duration is required when banning members");
        }
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.PATCH, "/im/v2/room_members/actions/chat_banned_tagged_members", "/im/v2/room_members/actions/chat_banned_tagged_members", null, requestBody);
        return ResultUtils.convert(apiResponse, ToggleTaggedMembersChatBanResponseV2.class);
    }

    @Override
    public Result<BatchQueryChatroomMembersResponseV2> batchQueryChatroomMembers(BatchQueryChatroomMembersRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getAccountIds() == null || request.getAccountIds().isEmpty()) {
            throw new IllegalArgumentException("Account IDs list cannot be null or empty");
        }
        String path = "/im/v2/room_members/{room_id}/actions/batch".replace("{room_id}", request.getRoomId().toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        String accountIdsParam = String.join((CharSequence)",", request.getAccountIds());
        queryParams.put("account_ids", accountIdsParam);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/room_members/{room_id}/actions/batch", path, queryParams, null);
        return ResultUtils.convert(apiResponse, BatchQueryChatroomMembersResponseV2.class);
    }

    @Override
    public Result<AddVirtualMembersResponseV2> addVirtualMembers(AddVirtualMembersRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getVirtualMembers() == null || request.getVirtualMembers().isEmpty()) {
            throw new IllegalArgumentException("Virtual members list cannot be null or empty");
        }
        for (AddVirtualMembersRequestV2.VirtualMemberInfoV2 member : request.getVirtualMembers()) {
            if (member.getAccountId() != null && !member.getAccountId().isEmpty()) continue;
            throw new IllegalArgumentException("Account ID of virtual member cannot be null or empty");
        }
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/room_members/actions/virtual_members", "/im/v2/room_members/actions/virtual_members", null, requestBody);
        return ResultUtils.convert(apiResponse, AddVirtualMembersResponseV2.class);
    }

    @Override
    public Result<DeleteVirtualMembersResponseV2> deleteVirtualMembers(DeleteVirtualMembersRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        if (request.getAccountIds() == null || request.getAccountIds().isEmpty()) {
            throw new IllegalArgumentException("Account IDs list cannot be null or empty");
        }
        for (String accountId : request.getAccountIds()) {
            if (accountId != null && !accountId.isEmpty()) continue;
            throw new IllegalArgumentException("Account ID cannot be null or empty");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("room_id", request.getRoomId().toString());
        queryParams.put("account_ids", String.join((CharSequence)",", request.getAccountIds()));
        if (request.getNotificationEnabled() != null) {
            queryParams.put("notification_enabled", request.getNotificationEnabled().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/room_members/actions/virtual_members", "/im/v2/room_members/actions/virtual_members", queryParams, null);
        return ResultUtils.convert(apiResponse, DeleteVirtualMembersResponseV2.class);
    }

    @Override
    public Result<ClearVirtualMembersResponseV2> clearVirtualMembers(ClearVirtualMembersRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("room_id", request.getRoomId().toString());
        if (request.getNotificationEnabled() != null) {
            queryParams.put("notification_enabled", request.getNotificationEnabled().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/room_members/actions/clear_virtual_members", "/im/v2/room_members/actions/clear_virtual_members", queryParams, null);
        return ResultUtils.convert(apiResponse, ClearVirtualMembersResponseV2.class);
    }

    @Override
    public Result<QueryVirtualMembersResponseV2> queryVirtualMembers(QueryVirtualMembersRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("room_id", request.getRoomId().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/room_members/actions/virtual_members", "/im/v2.1/room_members/actions/virtual_members", queryParams, null);
        return ResultUtils.convert(apiResponse, QueryVirtualMembersResponseV2.class);
    }

    @Override
    public Result<QueryChatBannedResponseV2> queryChatBanned(QueryChatBannedRequestV2 request) throws YunxinSdkException {
        if (request.getRoomId() == null) {
            throw new IllegalArgumentException("Chatroom ID cannot be null");
        }
        String path = "/im/v2.1/room_members/{room_id}/actions/chat_banned".replace("{room_id}", request.getRoomId().toString());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2.1/room_members/{room_id}/actions/chat_banned", path, null, null);
        return ResultUtils.convert(apiResponse, QueryChatBannedResponseV2.class);
    }
}

