/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v2.block;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.im.v2.block.IBlockV2Service;
import com.netease.nim.server.sdk.im.v2.block.request.AddBlockContactRequestV2;
import com.netease.nim.server.sdk.im.v2.block.request.ListBlockContactsRequestV2;
import com.netease.nim.server.sdk.im.v2.block.request.RemoveBlockContactRequestV2;
import com.netease.nim.server.sdk.im.v2.block.response.AddBlockContactResponseV2;
import com.netease.nim.server.sdk.im.v2.block.response.ListBlockContactsResponseV2;
import com.netease.nim.server.sdk.im.v2.block.response.RemoveBlockContactResponseV2;
import com.netease.nim.server.sdk.im.v2.util.ResultUtils;
import java.util.HashMap;

public class BlockV2Service
implements IBlockV2Service {
    private final YunxinApiHttpClient httpClient;

    public BlockV2Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<AddBlockContactResponseV2> addBlockContact(AddBlockContactRequestV2 request) throws YunxinSdkException {
        String requestBody = JSONObject.toJSONString((Object)request, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.POST, "/im/v2/block_contacts", "/im/v2/block_contacts", null, requestBody);
        return ResultUtils.convert(apiResponse, AddBlockContactResponseV2.class);
    }

    @Override
    public Result<RemoveBlockContactResponseV2> removeBlockContact(RemoveBlockContactRequestV2 request) throws YunxinSdkException {
        String path = "/im/v2/block_contacts/{account_id}".replace("{account_id}", request.getAccountId());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("contact_account_id", request.getContactAccountId());
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.DELETE, "/im/v2/block_contacts/{account_id}", path, queryParams, null);
        return ResultUtils.convert(apiResponse, RemoveBlockContactResponseV2.class);
    }

    @Override
    public Result<ListBlockContactsResponseV2> listBlockContacts(ListBlockContactsRequestV2 request) throws YunxinSdkException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("account_id", request.getAccountId());
        if (request.getPageToken() != null && !request.getPageToken().isEmpty()) {
            queryParams.put("page_token", request.getPageToken());
        }
        if (request.getLimit() != null) {
            queryParams.put("limit", request.getLimit().toString());
        }
        YunxinApiResponse apiResponse = this.httpClient.executeV2Api(HttpMethod.GET, "/im/v2/block_contacts", "/im/v2/block_contacts", queryParams, null);
        return ResultUtils.convert(apiResponse, ListBlockContactsResponseV2.class);
    }
}

