/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v1.history;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.im.v1.annotation.YunxinParamUtils;
import com.netease.nim.server.sdk.im.v1.history.IHistoryV1Service;
import com.netease.nim.server.sdk.im.v1.history.request.ChatroomMessage;
import com.netease.nim.server.sdk.im.v1.history.request.DeleteChatroomHistoryMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.history.request.Message;
import com.netease.nim.server.sdk.im.v1.history.request.QueryBroadcastHistoryMessageByIdRequestV1;
import com.netease.nim.server.sdk.im.v1.history.request.QueryBroadcastHistoryMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.history.request.QueryChatroomHistoryMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.history.request.QuerySessionHistoryMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.history.request.QuerySessionListRequestV1;
import com.netease.nim.server.sdk.im.v1.history.request.QueryTeamHistoryMessageRequestV1;
import com.netease.nim.server.sdk.im.v1.history.request.QueryUserEventsRequestV1;
import com.netease.nim.server.sdk.im.v1.history.response.DeleteChatroomHistoryMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.history.response.QueryBroadcastHistoryMessageByIdResponseV1;
import com.netease.nim.server.sdk.im.v1.history.response.QueryBroadcastHistoryMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.history.response.QueryChatroomHistoryMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.history.response.QuerySessionHistoryMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.history.response.QuerySessionListResponseV1;
import com.netease.nim.server.sdk.im.v1.history.response.QueryTeamHistoryMessageResponseV1;
import com.netease.nim.server.sdk.im.v1.history.response.QueryUserEventsResponseV1;
import com.netease.nim.server.sdk.im.v1.history.response.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HistoryV1Service
implements IHistoryV1Service {
    private final YunxinApiHttpClient httpClient;

    public HistoryV1Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<QuerySessionHistoryMessageResponseV1> querySessionHistoryMessage(QuerySessionHistoryMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/querySessionMsg.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QuerySessionHistoryMessageResponseV1 response = new QuerySessionHistoryMessageResponseV1();
        if (object.containsKey("size")) {
            response.setSize(object.getInteger("size"));
        }
        if (object.containsKey("msgs")) {
            String msgsStr = object.getString("msgs");
            List<Message> messages = this.parseTeamMessages(msgsStr);
            response.setMsgs(messages);
        }
        return new Result<QuerySessionHistoryMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryTeamHistoryMessageResponseV1> queryTeamHistoryMessage(QueryTeamHistoryMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/queryTeamMsg.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QueryTeamHistoryMessageResponseV1 response = new QueryTeamHistoryMessageResponseV1();
        if (object.containsKey("size")) {
            response.setSize(object.getInteger("size"));
        }
        if (object.containsKey("msgs")) {
            String msgsStr = object.getString("msgs");
            List<Message> messages = this.parseTeamMessages(msgsStr);
            response.setMsgs(messages);
        }
        return new Result<QueryTeamHistoryMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryChatroomHistoryMessageResponseV1> queryChatroomHistoryMessage(QueryChatroomHistoryMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/queryChatroomMsg.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QueryChatroomHistoryMessageResponseV1 response = new QueryChatroomHistoryMessageResponseV1();
        if (object.containsKey("size")) {
            response.setSize(object.getInteger("size"));
        }
        if (object.containsKey("msgs")) {
            String msgsStr = object.getString("msgs");
            List<ChatroomMessage> messages = this.parseChatroomMessages(msgsStr);
            response.setMsgs(messages);
        }
        return new Result<QueryChatroomHistoryMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    private List<Message> parseTeamMessages(String msgsStr) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (msgsStr != null && !msgsStr.isEmpty()) {
            JSONArray msgsArray = JSONArray.parseArray((String)msgsStr, (JSONReader.Feature[])new JSONReader.Feature[0]);
            for (int i = 0; i < msgsArray.size(); ++i) {
                JSONObject msgObject = msgsArray.getJSONObject(i);
                if (msgObject.containsKey("body")) {
                    Object bodyObj = msgObject.get("body");
                    if (bodyObj instanceof JSONObject) {
                        msgObject.put((Object)"body", (Object)((JSONObject)bodyObj).toJSONString(new JSONWriter.Feature[0]));
                    } else if (bodyObj != null) {
                        msgObject.put((Object)"body", (Object)bodyObj.toString());
                    }
                }
                Message message = Message.fromJson(msgObject);
                messages.add(message);
            }
        }
        return messages;
    }

    private List<ChatroomMessage> parseChatroomMessages(String msgsStr) {
        ArrayList<ChatroomMessage> messages = new ArrayList<ChatroomMessage>();
        if (msgsStr != null && !msgsStr.isEmpty()) {
            JSONArray msgsArray = JSONArray.parseArray((String)msgsStr, (JSONReader.Feature[])new JSONReader.Feature[0]);
            for (int i = 0; i < msgsArray.size(); ++i) {
                JSONObject msgObject = msgsArray.getJSONObject(i);
                if (msgObject.containsKey("body")) {
                    Object bodyObj = msgObject.get("body");
                    if (bodyObj instanceof JSONObject) {
                        msgObject.put((Object)"body", (Object)((JSONObject)bodyObj).toJSONString(new JSONWriter.Feature[0]));
                    } else if (bodyObj != null) {
                        msgObject.put((Object)"body", (Object)bodyObj.toString());
                    }
                }
                ChatroomMessage message = ChatroomMessage.fromJson(msgObject);
                messages.add(message);
            }
        }
        return messages;
    }

    @Override
    public Result<DeleteChatroomHistoryMessageResponseV1> deleteChatroomHistoryMessage(DeleteChatroomHistoryMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/chatroom/deleteHistoryMessage.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        DeleteChatroomHistoryMessageResponseV1 response = new DeleteChatroomHistoryMessageResponseV1();
        if (object.containsKey("data")) {
            response = (DeleteChatroomHistoryMessageResponseV1)JSON.parseObject((String)object.getString("data"), DeleteChatroomHistoryMessageResponseV1.class);
        }
        return new Result<DeleteChatroomHistoryMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QuerySessionListResponseV1> querySessionList(QuerySessionListRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/querySessionList.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QuerySessionListResponseV1 response = new QuerySessionListResponseV1();
        if (object.containsKey("data")) {
            JSONObject dataObject = object.getJSONObject("data");
            if (dataObject.containsKey("hasMore")) {
                response.setHasMore(dataObject.getBoolean("hasMore"));
            }
            if (dataObject.containsKey("sessions")) {
                JSONArray sessionsArray = dataObject.getJSONArray("sessions");
                ArrayList<Session> sessions = new ArrayList<Session>();
                for (int i = 0; i < sessionsArray.size(); ++i) {
                    JSONObject sessionObj = sessionsArray.getJSONObject(i);
                    Session session = new Session();
                    if (sessionObj.containsKey("sessionType")) {
                        session.setSessionType(sessionObj.getInteger("sessionType"));
                    }
                    if (sessionObj.containsKey("accid") && sessionObj.get("accid") != null) {
                        session.setAccid(sessionObj.getString("accid"));
                    }
                    if (sessionObj.containsKey("tid") && sessionObj.get("tid") != null) {
                        session.setTid(sessionObj.getLong("tid"));
                    }
                    if (sessionObj.containsKey("updateTime")) {
                        session.setUpdateTime(sessionObj.getLong("updateTime"));
                    }
                    if (sessionObj.containsKey("ext")) {
                        session.setExt(sessionObj.getString("ext"));
                    }
                    if (sessionObj.containsKey("lastMsgType")) {
                        session.setLastMsgType(sessionObj.getString("lastMsgType"));
                    }
                    if (sessionObj.containsKey("lastMsg")) {
                        session.setLastMsg(sessionObj.getString("lastMsg"));
                    }
                    sessions.add(session);
                }
                response.setSessions(sessions);
            }
        }
        return new Result<QuerySessionListResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryBroadcastHistoryMessageByIdResponseV1> queryBroadcastHistoryMessageById(QueryBroadcastHistoryMessageByIdRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/queryBroadcastMsgById.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QueryBroadcastHistoryMessageByIdResponseV1 response = new QueryBroadcastHistoryMessageByIdResponseV1();
        if (object.containsKey("msg")) {
            JSONObject msgObject = object.getJSONObject("msg");
            QueryBroadcastHistoryMessageByIdResponseV1.BroadcastMessage broadcastMsg = (QueryBroadcastHistoryMessageByIdResponseV1.BroadcastMessage)JSON.parseObject((String)msgObject.toJSONString(new JSONWriter.Feature[0]), QueryBroadcastHistoryMessageByIdResponseV1.BroadcastMessage.class);
            response.setMsg(broadcastMsg);
        }
        return new Result<QueryBroadcastHistoryMessageByIdResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryBroadcastHistoryMessageResponseV1> queryBroadcastHistoryMessage(QueryBroadcastHistoryMessageRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/queryBroadcastMsg.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QueryBroadcastHistoryMessageResponseV1 response = new QueryBroadcastHistoryMessageResponseV1();
        if (object.containsKey("msgs")) {
            JSONArray msgsArray = object.getJSONArray("msgs");
            ArrayList<QueryBroadcastHistoryMessageResponseV1.BroadcastMessage> broadcastMsgs = new ArrayList<QueryBroadcastHistoryMessageResponseV1.BroadcastMessage>();
            for (int i = 0; i < msgsArray.size(); ++i) {
                JSONObject msgObject = msgsArray.getJSONObject(i);
                QueryBroadcastHistoryMessageResponseV1.BroadcastMessage broadcastMsg = (QueryBroadcastHistoryMessageResponseV1.BroadcastMessage)JSON.parseObject((String)msgObject.toJSONString(new JSONWriter.Feature[0]), QueryBroadcastHistoryMessageResponseV1.BroadcastMessage.class);
                broadcastMsgs.add(broadcastMsg);
            }
            response.setMsgs(broadcastMsgs);
        }
        return new Result<QueryBroadcastHistoryMessageResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<QueryUserEventsResponseV1> queryUserEvents(QueryUserEventsRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api("/history/queryUserEvents.action", paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue("code");
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString("desc"), null);
        }
        QueryUserEventsResponseV1 response = new QueryUserEventsResponseV1();
        if (object.containsKey("events")) {
            ArrayList<QueryUserEventsResponseV1.UserEvent> userEvents = new ArrayList<QueryUserEventsResponseV1.UserEvent>();
            List events = (List)object.get("events");
            if (events != null) {
                for (Object evt : events) {
                    QueryUserEventsResponseV1.UserEvent userEvent = (QueryUserEventsResponseV1.UserEvent)JSON.toJavaObject((Object)((JSONObject)evt), QueryUserEventsResponseV1.UserEvent.class);
                    userEvents.add(userEvent);
                }
            }
            response.setEvents(userEvents);
        }
        if (object.containsKey("size")) {
            response.setSize((Integer)object.get("size"));
        }
        return new Result<QueryUserEventsResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }
}

