/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v1.friend;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.im.v1.annotation.YunxinParamUtils;
import com.netease.nim.server.sdk.im.v1.friend.FriendV1UrlContext;
import com.netease.nim.server.sdk.im.v1.friend.IFriendV1Service;
import com.netease.nim.server.sdk.im.v1.friend.request.AddFriendRequestV1;
import com.netease.nim.server.sdk.im.v1.friend.request.DeleteFriendRequestV1;
import com.netease.nim.server.sdk.im.v1.friend.request.GetFriendListRequestV1;
import com.netease.nim.server.sdk.im.v1.friend.request.GetFriendRelationshipRequestV1;
import com.netease.nim.server.sdk.im.v1.friend.request.UpdateFriendRequestV1;
import com.netease.nim.server.sdk.im.v1.friend.response.AddFriendResponseV1;
import com.netease.nim.server.sdk.im.v1.friend.response.DeleteFriendResponseV1;
import com.netease.nim.server.sdk.im.v1.friend.response.GetFriendListResponseV1;
import com.netease.nim.server.sdk.im.v1.friend.response.GetFriendRelationshipResponseV1;
import com.netease.nim.server.sdk.im.v1.friend.response.UpdateFriendResponseV1;
import java.util.List;
import java.util.Map;

public class FriendV1Service
implements IFriendV1Service {
    private final YunxinApiHttpClient httpClient;
    private static final String msg = "msg";
    private static final String CODE = "code";
    private static final String DESC = "desc";

    public FriendV1Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<AddFriendResponseV1> add(AddFriendRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api(FriendV1UrlContext.ADD, paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        AddFriendResponseV1 response = new AddFriendResponseV1();
        return new Result<AddFriendResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<UpdateFriendResponseV1> update(UpdateFriendRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api(FriendV1UrlContext.UPDATE, paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        UpdateFriendResponseV1 response = new UpdateFriendResponseV1();
        return new Result<UpdateFriendResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<DeleteFriendResponseV1> delete(DeleteFriendRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api(FriendV1UrlContext.DELETE, paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        DeleteFriendResponseV1 response = new DeleteFriendResponseV1();
        return new Result<DeleteFriendResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<GetFriendListResponseV1> get(GetFriendListRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api(FriendV1UrlContext.GET, paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        GetFriendListResponseV1 response = new GetFriendListResponseV1();
        if (object.containsKey("friends")) {
            List friends = JSON.parseArray((String)object.getString("friends"), GetFriendListResponseV1.FriendInfo.class);
            response.setFriends(friends);
        }
        return new Result<GetFriendListResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<GetFriendRelationshipResponseV1> getByAccId(GetFriendRelationshipRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api(FriendV1UrlContext.GET_BY_ACCID, paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        GetFriendRelationshipResponseV1 response = new GetFriendRelationshipResponseV1();
        if (object.containsKey("friend")) {
            response = (GetFriendRelationshipResponseV1)JSON.parseObject((String)object.getString("friend"), GetFriendRelationshipResponseV1.class);
        }
        return new Result<GetFriendRelationshipResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }
}

