/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.im.v1.chatroom_message;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.netease.nim.server.sdk.core.Result;
import com.netease.nim.server.sdk.core.YunxinApiHttpClient;
import com.netease.nim.server.sdk.core.YunxinApiResponse;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.im.v1.annotation.YunxinParamUtils;
import com.netease.nim.server.sdk.im.v1.chatroom_message.ChatroomMessageV1UrlContext;
import com.netease.nim.server.sdk.im.v1.chatroom_message.IChatroomMessageV1Service;
import com.netease.nim.server.sdk.im.v1.chatroom_message.request.BatchChatroomTargetMsgRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.request.BatchSendChatroomMsgRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.request.ChatroomBroadcastRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.request.ChatroomTargetMsgRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.request.RecallChatroomMsgRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.request.SendChatroomMsgRequestV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.response.BatchChatroomTargetMsgResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.response.BatchSendChatroomMsgResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.response.ChatroomTargetMsgResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.response.RecallChatroomMsgResponseV1;
import com.netease.nim.server.sdk.im.v1.chatroom_message.response.SendChatroomMsgResponseV1;
import java.util.ArrayList;
import java.util.Map;

public class ChatroomMessageV1Service
implements IChatroomMessageV1Service {
    private final YunxinApiHttpClient httpClient;
    private static final String CODE = "code";
    private static final String DESC = "desc";

    public ChatroomMessageV1Service(YunxinApiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Result<SendChatroomMsgResponseV1> sendMsg(SendChatroomMsgRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api(ChatroomMessageV1UrlContext.SEND_MSG, paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        SendChatroomMsgResponseV1 response = new SendChatroomMsgResponseV1();
        if (object.containsKey(DESC)) {
            response = (SendChatroomMsgResponseV1)JSON.parseObject((String)object.getString(DESC), SendChatroomMsgResponseV1.class);
        }
        return new Result<SendChatroomMsgResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<BatchSendChatroomMsgResponseV1> batchSendMsg(BatchSendChatroomMsgRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject jsonObject;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getMsgList() != null) {
            paramMap.put("msgList", JSON.toJSONString(request.getMsgList()));
        }
        if ((code = (jsonObject = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api(ChatroomMessageV1UrlContext.BATCH_SEND_MSG, paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), jsonObject.getString(DESC), null);
        }
        ArrayList<BatchSendChatroomMsgResponseV1.FailedMessage> failList = new ArrayList<BatchSendChatroomMsgResponseV1.FailedMessage>();
        if (jsonObject.containsKey("fail")) {
            JSONArray failArray = jsonObject.getJSONArray("fail");
            for (int i = 0; i < failArray.size(); ++i) {
                JSONObject failObject = failArray.getJSONObject(i);
                for (String key : failObject.keySet()) {
                    BatchSendChatroomMsgResponseV1.FailedMessage failedMessage = new BatchSendChatroomMsgResponseV1.FailedMessage();
                    failedMessage.setClientMsgId(key);
                    failedMessage.setReason(failObject.getString(key));
                    failList.add(failedMessage);
                }
            }
        }
        ArrayList<BatchSendChatroomMsgResponseV1.SuccessfulMessage> successList = new ArrayList<BatchSendChatroomMsgResponseV1.SuccessfulMessage>();
        if (jsonObject.containsKey("success")) {
            JSONArray successArray = jsonObject.getJSONArray("success");
            for (int i = 0; i < successArray.size(); ++i) {
                JSONObject successObject = successArray.getJSONObject(i);
                for (String key : successObject.keySet()) {
                    BatchSendChatroomMsgResponseV1.SuccessfulMessage msg = (BatchSendChatroomMsgResponseV1.SuccessfulMessage)JSONObject.parseObject((String)successObject.getString(key), BatchSendChatroomMsgResponseV1.SuccessfulMessage.class);
                    msg.setClientMsgId(key);
                    successList.add(msg);
                }
            }
        }
        BatchSendChatroomMsgResponseV1 response = new BatchSendChatroomMsgResponseV1();
        response.setFailList(failList);
        response.setSuccessList(successList);
        return new Result<BatchSendChatroomMsgResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<RecallChatroomMsgResponseV1> recall(RecallChatroomMsgRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api(ChatroomMessageV1UrlContext.RECALL, paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        RecallChatroomMsgResponseV1 response = new RecallChatroomMsgResponseV1();
        return new Result<RecallChatroomMsgResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<ChatroomTargetMsgResponseV1> sendMsgToSomeone(ChatroomTargetMsgRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject object;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getToAccids() != null) {
            paramMap.put("toAccids", JSON.toJSONString(request.getToAccids()));
        }
        if ((code = (object = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api(ChatroomMessageV1UrlContext.SEND_MSG_TO_SOMEONE, paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        ChatroomTargetMsgResponseV1 response = new ChatroomTargetMsgResponseV1();
        if (object.containsKey(DESC)) {
            response = (ChatroomTargetMsgResponseV1)JSON.parseObject((String)object.getString(DESC), ChatroomTargetMsgResponseV1.class);
        }
        return new Result<ChatroomTargetMsgResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<BatchChatroomTargetMsgResponseV1> batchSendMsgToSomeone(BatchChatroomTargetMsgRequestV1 request) throws YunxinSdkException {
        YunxinApiResponse apiResponse;
        JSONObject jsonObject;
        int code;
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        if (request.getMsgList() != null) {
            paramMap.put("msgList", JSON.toJSONString(request.getMsgList()));
        }
        if (request.getToAccids() != null) {
            paramMap.put("toAccids", JSON.toJSONString(request.getToAccids()));
        }
        if ((code = (jsonObject = JSONObject.parseObject((String)(apiResponse = this.httpClient.executeV1Api(ChatroomMessageV1UrlContext.BATCH_SEND_MSG_TO_SOMEONE, paramMap)).getData())).getIntValue(CODE)) != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), jsonObject.getString(DESC), null);
        }
        ArrayList<BatchChatroomTargetMsgResponseV1.FailedMessage> failList = new ArrayList<BatchChatroomTargetMsgResponseV1.FailedMessage>();
        if (jsonObject.containsKey("fail")) {
            JSONArray failArray = jsonObject.getJSONArray("fail");
            for (int i = 0; i < failArray.size(); ++i) {
                JSONObject failObject = failArray.getJSONObject(i);
                for (String key : failObject.keySet()) {
                    BatchChatroomTargetMsgResponseV1.FailedMessage failedMessage = new BatchChatroomTargetMsgResponseV1.FailedMessage();
                    failedMessage.setClientMsgId(key);
                    failedMessage.setReason(failObject.getString(key));
                    failList.add(failedMessage);
                }
            }
        }
        ArrayList<ChatroomTargetMsgResponseV1> successList = new ArrayList<ChatroomTargetMsgResponseV1>();
        if (jsonObject.containsKey("success")) {
            JSONArray successArray = jsonObject.getJSONArray("success");
            for (int i = 0; i < successArray.size(); ++i) {
                JSONObject successObject = successArray.getJSONObject(i);
                for (String key : successObject.keySet()) {
                    ChatroomTargetMsgResponseV1 msg = (ChatroomTargetMsgResponseV1)JSONObject.parseObject((String)successObject.getString(key), ChatroomTargetMsgResponseV1.class);
                    msg.setMsgidClient(key);
                    successList.add(msg);
                }
            }
        }
        BatchChatroomTargetMsgResponseV1 response = new BatchChatroomTargetMsgResponseV1();
        response.setFailList(failList);
        response.setSuccessList(successList);
        return new Result<BatchChatroomTargetMsgResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }

    @Override
    public Result<SendChatroomMsgResponseV1> broadcast(ChatroomBroadcastRequestV1 request) throws YunxinSdkException {
        Map<String, String> paramMap = YunxinParamUtils.convert(request);
        YunxinApiResponse apiResponse = this.httpClient.executeV1Api(ChatroomMessageV1UrlContext.BROADCAST, paramMap);
        JSONObject object = JSONObject.parseObject((String)apiResponse.getData());
        int code = object.getIntValue(CODE);
        if (code != 200) {
            return new Result<Object>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), object.getString(DESC), null);
        }
        SendChatroomMsgResponseV1 response = new SendChatroomMsgResponseV1();
        if (object.containsKey(DESC)) {
            response = (SendChatroomMsgResponseV1)JSON.parseObject((String)object.getString(DESC), SendChatroomMsgResponseV1.class);
        }
        return new Result<SendChatroomMsgResponseV1>(apiResponse.getEndpoint(), code, apiResponse.getTraceId(), null, response);
    }
}

