/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.endpoint;

import com.netease.nim.server.sdk.core.endpoint.ExecuteContext;

public interface RetryPolicy {
    public static final long[] intervalArray = new long[]{0L, 5L, 10L, 50L, 100L, 500L, 1000L, 5000L};

    default public int maxRetry() {
        return 1;
    }

    default public long retryInterval(ExecuteContext retryContext, int retry) {
        if (retry >= intervalArray.length) {
            return intervalArray[intervalArray.length - 1];
        }
        return intervalArray[retry];
    }

    default public RetryAction onError(ExecuteContext retryContext, int retry, Throwable error) {
        return RetryAction.NO_RETRY;
    }

    public static class RetryAction {
        public static RetryAction NO_RETRY = new RetryAction(false, false);
        public static RetryAction RETRY_CURRENT = new RetryAction(true, false);
        public static RetryAction RETRY_NEXT = new RetryAction(true, true);
        private final boolean retry;
        private final boolean nextEndpoint;

        public RetryAction(boolean retry, boolean nextEndpoint) {
            this.retry = retry;
            this.nextEndpoint = nextEndpoint;
        }

        public boolean isRetry() {
            return this.retry;
        }

        public boolean isNextEndpoint() {
            return this.nextEndpoint;
        }
    }
}

