/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.endpoint;

import com.netease.nim.server.sdk.core.BizName;
import com.netease.nim.server.sdk.core.endpoint.EndpointFetcher;
import com.netease.nim.server.sdk.core.endpoint.Endpoints;
import com.netease.nim.server.sdk.core.endpoint.Region;
import com.netease.nim.server.sdk.core.exception.EndpointFetchException;
import java.util.ArrayList;
import java.util.Arrays;
import okhttp3.OkHttpClient;

public class LocalEndpointFetcher
implements EndpointFetcher {
    private final Endpoints endpoints = new Endpoints();

    public LocalEndpointFetcher(String defaultEndpoint, String ... backUpEndpoints) {
        this.endpoints.setDefaultEndpoint(defaultEndpoint);
        if (backUpEndpoints != null) {
            ArrayList<String> backupEndpoints = new ArrayList<String>(Arrays.asList(backUpEndpoints));
            this.endpoints.setBackupEndpoints(backupEndpoints);
        }
    }

    public LocalEndpointFetcher(Region region) {
        this(BizName.IM, region);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LocalEndpointFetcher(BizName bizName, Region region) {
        if (bizName == BizName.IM) {
            if (region == Region.CN) {
                this.endpoints.setDefaultEndpoint("https://api-cn.yunxinapi.com/nimserver");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://api-cn-bak.yunxinapi.com/nimserver");
                backupEndpoints.add("https://api-cn-01.yunxinapi.com/nimserver");
                backupEndpoints.add("https://api-cn-02.yunxinapi.com/nimserver");
                backupEndpoints.add("https://api-cn-03.yunxinapi.com/nimserver");
                this.endpoints.setBackupEndpoints(backupEndpoints);
                return;
            } else {
                if (region != Region.SG) throw new EndpointFetchException("unknown region");
                this.endpoints.setDefaultEndpoint("https://api-sg.yunxinapi.com/nimserver");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://api-sg-bak.yunxinapi.com/nimserver");
                backupEndpoints.add("https://api-sg-01.yunxinapi.com/nimserver");
                backupEndpoints.add("https://api-sg-02.yunxinapi.com/nimserver");
                backupEndpoints.add("https://api-sg-03.yunxinapi.com/nimserver");
                this.endpoints.setBackupEndpoints(backupEndpoints);
            }
            return;
        } else if (bizName == BizName.RTC) {
            if (region == Region.CN) {
                this.endpoints.setDefaultEndpoint("https://rtc.yunxinapi.com");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://rtc-pri.yunxinapi.com");
                backupEndpoints.add("https://rtc-bak.yunxinapi.com");
                this.endpoints.setBackupEndpoints(backupEndpoints);
                return;
            } else {
                if (region != Region.SG) throw new EndpointFetchException("unknown region");
                this.endpoints.setDefaultEndpoint("https://rtc-ap.yunxinapi.com");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://rtc-ap-bak.yunxinapi.com");
                this.endpoints.setBackupEndpoints(backupEndpoints);
            }
            return;
        } else if (bizName == BizName.SMS) {
            if (region != Region.CN) throw new EndpointFetchException("unknown region");
            this.endpoints.setDefaultEndpoint("https://sms.yunxinapi.com/sms");
            ArrayList<String> backupEndpoints = new ArrayList<String>();
            backupEndpoints.add("https://sms-backup.yunxinapi.com/sms");
            this.endpoints.setBackupEndpoints(backupEndpoints);
            return;
        } else if (bizName == BizName.LIVE) {
            if (region == Region.CN) {
                this.endpoints.setDefaultEndpoint("https://vcloud.yunxinapi.com");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://vcloud.163.com");
                this.endpoints.setBackupEndpoints(backupEndpoints);
                return;
            } else {
                if (region != Region.SG) throw new EndpointFetchException("unknown region");
                this.endpoints.setDefaultEndpoint("https://vcloud-sea.yunxinapi.com");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://api-sea.yunxinvcloud.com");
                this.endpoints.setBackupEndpoints(backupEndpoints);
            }
            return;
        } else if (bizName == BizName.VOD) {
            if (region == Region.CN) {
                this.endpoints.setDefaultEndpoint("https://vcloud.yunxinapi.com");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://vcloud.163.com");
                this.endpoints.setBackupEndpoints(backupEndpoints);
                return;
            } else {
                if (region != Region.SG) throw new EndpointFetchException("unknown region");
                this.endpoints.setDefaultEndpoint("https://vcloud-sea.yunxinapi.com");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://api-sea.yunxinvcloud.com");
                this.endpoints.setBackupEndpoints(backupEndpoints);
            }
            return;
        } else if (bizName == BizName.MEETING) {
            if (region != Region.CN) throw new EndpointFetchException("unknown region");
            this.endpoints.setDefaultEndpoint("https://roomkit-alt1.yunxinapi.com");
            ArrayList<String> backupEndpoints = new ArrayList<String>();
            backupEndpoints.add("https://roomkit-alt2.yunxinapi.com");
            this.endpoints.setBackupEndpoints(backupEndpoints);
            return;
        } else {
            if (bizName != BizName.NEROOM) throw new EndpointFetchException("unknown bizName");
            if (region == Region.CN) {
                this.endpoints.setDefaultEndpoint("https://roomkit-alt1.yunxinapi.com");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://roomkit-alt2.yunxinapi.com");
                this.endpoints.setBackupEndpoints(backupEndpoints);
                return;
            } else {
                if (region != Region.SG) throw new EndpointFetchException("unknown region");
                this.endpoints.setDefaultEndpoint("https://roomkit-sg.yunxinapi.com");
                ArrayList<String> backupEndpoints = new ArrayList<String>();
                backupEndpoints.add("https://roomkit-sg-alt1.yunxinapi.com");
                this.endpoints.setBackupEndpoints(backupEndpoints);
            }
        }
    }

    @Override
    public void init(OkHttpClient okHttpClient) {
    }

    @Override
    public Endpoints get() {
        return this.endpoints;
    }
}

