/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.endpoint;

import com.netease.nim.server.sdk.core.BizName;
import com.netease.nim.server.sdk.core.endpoint.EndpointFetcher;
import com.netease.nim.server.sdk.core.endpoint.EndpointSelector;
import com.netease.nim.server.sdk.core.endpoint.Endpoints;
import com.netease.nim.server.sdk.core.endpoint.LatencySlideWindows;
import com.netease.nim.server.sdk.core.endpoint.RatioSlideWindows;
import com.netease.nim.server.sdk.core.endpoint.RequestResult;
import com.netease.nim.server.sdk.core.exception.EndpointFetchException;
import com.netease.nim.server.sdk.core.utils.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEndpointSelector
implements EndpointSelector {
    private static final Logger logger = LoggerFactory.getLogger(DynamicEndpointSelector.class);
    private static final ScheduledExecutorService scheduler1 = Executors.newScheduledThreadPool(BizName.values().length, new NamedThreadFactory("yunxin-sdk-detect"));
    private static final ScheduledExecutorService scheduler2 = Executors.newScheduledThreadPool(BizName.values().length, new NamedThreadFactory("yunxin-sdk-schedule"));
    private final EndpointFetcher fetcher;
    private final int scheduleDetectIntervalSeconds;
    private final int scheduleResultIntervalSeconds;
    private final int slideWindowBuckets;
    private final long slideWindowTime;
    private String defaultEndpoint;
    private List<String> backupEndpoints;
    private final String detectPath;
    private final Map<String, RatioSlideWindows> ratioMap = new ConcurrentHashMap<String, RatioSlideWindows>();
    private final Map<String, LatencySlideWindows> latencyMap = new ConcurrentHashMap<String, LatencySlideWindows>();
    private OkHttpClient okHttpClient;
    private List<String> orderedEndpoints = new ArrayList<String>();
    private ScheduledFuture<?> scheduleResultFuture;
    private ScheduledFuture<?> scheduleDetectFuture;

    public DynamicEndpointSelector(EndpointFetcher fetcher) {
        this(fetcher, BizName.IM.getDetectPath(), 5, 10, 12, 5000L);
    }

    public DynamicEndpointSelector(BizName bizName, EndpointFetcher fetcher) {
        this(bizName, fetcher, 5, 10, 12, 5000L);
    }

    public DynamicEndpointSelector(EndpointFetcher fetcher, String detectPath) {
        this(fetcher, detectPath, 5, 10, 12, 5000L);
    }

    public DynamicEndpointSelector(EndpointFetcher fetcher, String detectPath, int scheduleDetectIntervalSeconds, int scheduleResultIntervalSeconds, int slideWindowBuckets, long slideWindowTime) {
        this.fetcher = fetcher;
        this.detectPath = detectPath;
        this.scheduleDetectIntervalSeconds = scheduleDetectIntervalSeconds;
        this.scheduleResultIntervalSeconds = scheduleResultIntervalSeconds;
        this.slideWindowBuckets = slideWindowBuckets;
        this.slideWindowTime = slideWindowTime;
    }

    public DynamicEndpointSelector(BizName bizName, EndpointFetcher fetcher, int scheduleDetectIntervalSeconds, int scheduleResultIntervalSeconds, int slideWindowBuckets, long slideWindowTime) {
        this.fetcher = fetcher;
        this.detectPath = bizName.getDetectPath();
        this.scheduleDetectIntervalSeconds = scheduleDetectIntervalSeconds;
        this.scheduleResultIntervalSeconds = scheduleResultIntervalSeconds;
        this.slideWindowBuckets = slideWindowBuckets;
        this.slideWindowTime = slideWindowTime;
    }

    @Override
    public void init(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        this.fetcher.init(okHttpClient);
        Endpoints endpoints = this.fetcher.get();
        if (endpoints == null) {
            throw new EndpointFetchException("endpoints fetch null");
        }
        this.defaultEndpoint = endpoints.getDefaultEndpoint();
        this.backupEndpoints = endpoints.getBackupEndpoints();
        if (this.defaultEndpoint == null) {
            throw new EndpointFetchException("default endpoint is null");
        }
        this.orderedEndpoints.add(this.defaultEndpoint);
        if (this.backupEndpoints != null) {
            this.orderedEndpoints.addAll(this.backupEndpoints);
        }
        if (this.detectPath != null) {
            this.scheduleDetectFuture = scheduler1.scheduleAtFixedRate(this::scheduleDetect, this.scheduleDetectIntervalSeconds, this.scheduleDetectIntervalSeconds, TimeUnit.SECONDS);
        }
        this.scheduleResultFuture = scheduler2.scheduleAtFixedRate(this::scheduleResult, this.scheduleResultIntervalSeconds, this.scheduleResultIntervalSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() {
        if (this.scheduleResultFuture != null) {
            this.scheduleResultFuture.cancel(false);
        }
        if (this.scheduleDetectFuture != null) {
            this.scheduleDetectFuture.cancel(false);
        }
    }

    @Override
    public void update(String endpoint, RequestResult result) {
        RatioSlideWindows windows = this.getRatioSlideWindows(endpoint);
        if (result == RequestResult.SUCCESS) {
            windows.incrementSuccess();
        } else {
            windows.incrementFail();
        }
    }

    @Override
    public String selectEndpoint(String excludeEndpoint) {
        if (this.backupEndpoints == null || this.backupEndpoints.isEmpty()) {
            return this.defaultEndpoint;
        }
        try {
            for (String endpoint : this.orderedEndpoints) {
                if (Objects.equals(endpoint, excludeEndpoint)) continue;
                return endpoint;
            }
            return this.defaultEndpoint;
        }
        catch (Exception e) {
            return this.defaultEndpoint;
        }
    }

    private void scheduleResult() {
        try {
            this.fetchEndpoints();
            RatioSlideWindows ratioSlideWindows = this.getRatioSlideWindows(this.defaultEndpoint);
            LatencySlideWindows latencySlideWindows = this.getLatencySlideWindows(this.defaultEndpoint);
            ArrayList<Entry> list = new ArrayList<Entry>();
            list.add(new Entry(this.defaultEndpoint, ratioSlideWindows.getSuccessRatio(), latencySlideWindows.getLatency(), true));
            for (String backupEndpoint : this.backupEndpoints) {
                RatioSlideWindows backUpRatioSlideWindows = this.getRatioSlideWindows(backupEndpoint);
                LatencySlideWindows backUpLatencySlideWindows = this.getLatencySlideWindows(backupEndpoint);
                list.add(new Entry(backupEndpoint, backUpRatioSlideWindows.getSuccessRatio(), backUpLatencySlideWindows.getLatency(), false));
            }
            Collections.sort(list);
            ArrayList<String> result = new ArrayList<String>();
            for (Entry entry : list) {
                result.add(entry.endpoint);
            }
            if (logger.isDebugEnabled()) {
                for (Entry entry : list) {
                    logger.debug("endpoint = {}, default-endpoint = {}, ratio = {}, latency = {}", new Object[]{entry.endpoint, entry.defaultEndpoint, entry.ratio, entry.latency});
                }
            }
            this.orderedEndpoints = result;
        }
        catch (Exception e) {
            logger.error("schedule result error", (Throwable)e);
        }
    }

    private void scheduleDetect() {
        try {
            this.fetchEndpoints();
            this.check(this.defaultEndpoint);
            for (String backupEndpoint : this.backupEndpoints) {
                this.check(backupEndpoint);
            }
        }
        catch (Exception e) {
            logger.error("schedule detect error", (Throwable)e);
        }
    }

    private void fetchEndpoints() {
        try {
            Endpoints endpoints = this.fetcher.get();
            if (endpoints == null) {
                logger.error("fetch endpoints error, endpoints is null");
                return;
            }
            String defaultEndpoint = endpoints.getDefaultEndpoint();
            if (defaultEndpoint == null) {
                logger.error("fetch endpoints error, default endpoint is null");
                return;
            }
            List<String> backupEndpoints = endpoints.getBackupEndpoints();
            this.defaultEndpoint = defaultEndpoint;
            this.backupEndpoints = backupEndpoints;
        }
        catch (Exception e) {
            logger.error("fetch error", (Throwable)e);
        }
    }

    private void check(String endpoint) {
        boolean success;
        if (this.okHttpClient == null) {
            return;
        }
        String url = endpoint + this.detectPath;
        Request request = new Request.Builder().get().url(url).build();
        long startTime = System.currentTimeMillis();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            String string = response.body().string();
            boolean bl = success = response.code() == 200;
            if (logger.isDebugEnabled()) {
                logger.debug("detect, endpoint = {}, path = {}, code = {}, response = {}", new Object[]{endpoint, this.detectPath, response.code(), string});
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("detect error, endpoint = {}, path = {}", new Object[]{endpoint, this.detectPath, e});
            }
            success = false;
        }
        LatencySlideWindows latencySlideWindows = this.getLatencySlideWindows(endpoint);
        latencySlideWindows.increment(System.currentTimeMillis() - startTime);
        RatioSlideWindows ratioSlideWindows = this.getRatioSlideWindows(endpoint);
        if (success) {
            ratioSlideWindows.incrementSuccess();
        } else {
            ratioSlideWindows.incrementFail();
        }
    }

    private RatioSlideWindows getRatioSlideWindows(String endpoint) {
        RatioSlideWindows windows = this.ratioMap.get(endpoint);
        if (windows == null) {
            windows = this.ratioMap.computeIfAbsent(endpoint, s -> new RatioSlideWindows(this.slideWindowBuckets, this.slideWindowTime));
        }
        return windows;
    }

    private LatencySlideWindows getLatencySlideWindows(String endpoint) {
        LatencySlideWindows windows = this.latencyMap.get(endpoint);
        if (windows == null) {
            windows = this.latencyMap.computeIfAbsent(endpoint, s -> new LatencySlideWindows(this.slideWindowBuckets, this.slideWindowTime));
        }
        return windows;
    }

    public static final class Entry
    implements Comparable<Entry> {
        public String endpoint;
        public double ratio;
        public double latency;
        public boolean defaultEndpoint;

        public Entry(String endpoint, double ratio, double latency, boolean defaultEndpoint) {
            this.endpoint = endpoint;
            this.ratio = ratio;
            this.latency = latency;
            this.defaultEndpoint = defaultEndpoint;
        }

        @Override
        public int compareTo(Entry o) {
            if (this.ratio >= 1.0 && o.ratio >= 1.0) {
                int compare = Double.compare(this.latency, o.latency);
                if (compare == 0 && this.defaultEndpoint) {
                    return -1;
                }
                return compare;
            }
            if (this.ratio < 1.0 && this.ratio >= 0.999 && o.ratio < 1.0 && o.ratio >= 0.999) {
                return Double.compare(this.latency, o.latency);
            }
            int compare = Double.compare(o.ratio, this.ratio);
            if (compare != 0) {
                return compare;
            }
            return Double.compare(this.latency, o.latency);
        }
    }
}

