/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.endpoint;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.netease.nim.server.sdk.core.BizName;
import com.netease.nim.server.sdk.core.endpoint.EndpointFetcher;
import com.netease.nim.server.sdk.core.endpoint.Endpoints;
import com.netease.nim.server.sdk.core.endpoint.Region;
import com.netease.nim.server.sdk.core.exception.EndpointFetchException;
import com.netease.nim.server.sdk.core.http.ParamBuilder;
import com.netease.nim.server.sdk.core.utils.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEndpointFetcher
implements EndpointFetcher {
    private static final Logger logger = LoggerFactory.getLogger(DynamicEndpointFetcher.class);
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("yunxin-sdk-endpoint-fetch"));
    private final BizName bizName;
    private final String appkey;
    private final List<String> lbsList;
    private final int reloadIntervalSeconds;
    private final String detectPath;
    private OkHttpClient okHttpClient;
    private String md5;
    private Endpoints endpoints;
    private long nextFetchTime;

    public DynamicEndpointFetcher(String appkey) {
        this(appkey, null);
    }

    public DynamicEndpointFetcher(BizName bizName, String appkey) {
        this(bizName, appkey, (Region)null);
    }

    public DynamicEndpointFetcher(String appkey, Region region) {
        this(BizName.IM, appkey, region);
    }

    public DynamicEndpointFetcher(BizName bizName, String appkey, String detectPath) {
        this.bizName = bizName;
        this.detectPath = detectPath;
        this.appkey = appkey;
        this.lbsList = Arrays.asList("https://srv-sdk-lbs.yunxinapi.com/srv-sdk/allocate", "https://srv-sdk-lbs-cn.yunxinapi.com/srv-sdk/allocate", "https://srv-sdk-lbs-sg.yunxinapi.com/srv-sdk/allocate");
        this.reloadIntervalSeconds = 60;
    }

    public DynamicEndpointFetcher(BizName bizName, String appkey, String detectPath, Region region) {
        this.bizName = bizName;
        this.detectPath = detectPath;
        this.appkey = appkey;
        this.lbsList = region == Region.CN ? Collections.singletonList("https://srv-sdk-lbs-cn.yunxinapi.com/srv-sdk/allocate") : (region == Region.SG ? Collections.singletonList("https://srv-sdk-lbs-sg.yunxinapi.com/srv-sdk/allocate") : Arrays.asList("https://srv-sdk-lbs.yunxinapi.com/srv-sdk/allocate", "https://srv-sdk-lbs-cn.yunxinapi.com/srv-sdk/allocate", "https://srv-sdk-lbs-sg.yunxinapi.com/srv-sdk/allocate"));
        this.reloadIntervalSeconds = 60;
    }

    public DynamicEndpointFetcher(BizName bizName, String appkey, Region region) {
        this.bizName = bizName;
        this.detectPath = bizName.getDetectPath();
        this.appkey = appkey;
        this.lbsList = region == Region.CN ? Collections.singletonList("https://srv-sdk-lbs-cn.yunxinapi.com/srv-sdk/allocate") : (region == Region.SG ? Collections.singletonList("https://srv-sdk-lbs-sg.yunxinapi.com/srv-sdk/allocate") : Arrays.asList("https://srv-sdk-lbs.yunxinapi.com/srv-sdk/allocate", "https://srv-sdk-lbs-cn.yunxinapi.com/srv-sdk/allocate", "https://srv-sdk-lbs-sg.yunxinapi.com/srv-sdk/allocate"));
        this.reloadIntervalSeconds = 60;
    }

    public DynamicEndpointFetcher(String appkey, List<String> lbsList, int reloadIntervalSeconds) {
        this(BizName.IM, appkey, lbsList, reloadIntervalSeconds);
    }

    public DynamicEndpointFetcher(BizName bizName, String appkey, List<String> lbsList, int reloadIntervalSeconds) {
        this.bizName = bizName;
        this.detectPath = bizName.getDetectPath();
        this.appkey = appkey;
        this.lbsList = lbsList;
        this.reloadIntervalSeconds = reloadIntervalSeconds;
    }

    @Override
    public void init(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        for (int i = 0; i < 3; ++i) {
            for (String lbs : this.lbsList) {
                try {
                    boolean reload = this.reload(lbs);
                    if (!reload) continue;
                    break;
                }
                catch (Exception e) {
                    logger.error("fetch endpoints error, lbs = {}", (Object)lbs, (Object)e);
                }
            }
            if (this.endpoints != null) break;
        }
        if (this.endpoints == null) {
            throw new EndpointFetchException("init endpoints error");
        }
        scheduler.scheduleAtFixedRate(() -> {
            for (String lbs : this.lbsList) {
                try {
                    boolean reload = this.reload(lbs);
                    if (!reload) continue;
                    break;
                }
                catch (Exception e) {
                    logger.error("fetch endpoints error, lbs = {}", (Object)lbs, (Object)e);
                }
            }
        }, this.reloadIntervalSeconds, this.reloadIntervalSeconds, TimeUnit.SECONDS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reload(String lbs) {
        ArrayList<String> backupEndpoints;
        Endpoints endpoints;
        String defaultEndpoint;
        JSONObject data;
        boolean existsSkip;
        String string;
        block41: {
            Iterator iterator;
            block42: {
                if (System.currentTimeMillis() < this.nextFetchTime) {
                    return true;
                }
                ParamBuilder builder = new ParamBuilder();
                builder.addParam("k", this.appkey);
                builder.addParam("sv", "1.1.2");
                if (this.md5 != null) {
                    builder.addParam("md5", this.md5);
                }
                builder.addParam("biz", this.bizName.getValue());
                Request request = new Request.Builder().get().url(lbs + "?" + builder.build()).build();
                string = null;
                try (Response response = this.okHttpClient.newCall(request).execute();){
                    JSONObject json;
                    Integer code;
                    if (response.code() != 200) {
                        logger.error("fetch endpoints error, http.code = {}", (Object)response.code());
                        throw new EndpointFetchException("http.code=" + response.code());
                    }
                    string = response.body().string();
                    if (logger.isDebugEnabled()) {
                        logger.debug("fetch endpoints, lbs = {}, response = {}", (Object)lbs, (Object)string);
                    }
                    if ((code = (json = JSONObject.parseObject((String)string)).getInteger("code")) == null) {
                        logger.error("illegal endpoints, response = {}", (Object)string);
                        boolean bl = false;
                        return bl;
                    }
                    if (code == 304) {
                        boolean bl = true;
                        return bl;
                    }
                    if (code == 200) {
                        existsSkip = false;
                        data = json.getJSONObject("data");
                        defaultEndpoint = data.getString("default.endpoint");
                        if (!this.check(defaultEndpoint)) {
                            logger.error("default endpoint check error, skip, endpoint = {}", (Object)defaultEndpoint);
                            defaultEndpoint = null;
                            existsSkip = true;
                        }
                        JSONArray backupEndpointsJson = data.getJSONArray("backup.endpoints");
                        endpoints = new Endpoints();
                        backupEndpoints = new ArrayList<String>();
                        if (backupEndpointsJson == null) break block41;
                        iterator = backupEndpointsJson.iterator();
                        break block42;
                    }
                    logger.error("fetch endpoints error, response = {}", (Object)string);
                    boolean bl = false;
                    return bl;
                }
                catch (EndpointFetchException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error("fetch endpoints error, response = {}", string, (Object)e);
                    throw new EndpointFetchException(e);
                }
            }
            while (iterator.hasNext()) {
                Object backupEndpoint = iterator.next();
                if (!this.check(String.valueOf(backupEndpoint))) {
                    logger.error("backup endpoint check error, skip, endpoint = {}", (Object)defaultEndpoint);
                    existsSkip = true;
                    continue;
                }
                if (defaultEndpoint == null) {
                    defaultEndpoint = String.valueOf(backupEndpoint);
                    continue;
                }
                backupEndpoints.add(String.valueOf(backupEndpoint));
            }
        }
        endpoints.setDefaultEndpoint(defaultEndpoint);
        endpoints.setBackupEndpoints(backupEndpoints);
        if (defaultEndpoint == null) {
            logger.error("illegal endpoints, response = {}", (Object)string);
            return false;
        }
        logger.info("endpoints update, old = {}, new = {}", (Object)JSONObject.toJSONString((Object)this.endpoints, (JSONWriter.Feature[])new JSONWriter.Feature[0]), (Object)JSONObject.toJSONString((Object)endpoints, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        int ttl = data.getIntValue("ttl", 30);
        if (ttl <= 0 || ttl > 86400) {
            ttl = 30;
        }
        this.nextFetchTime = System.currentTimeMillis() + (long)ttl * 1000L;
        if (!existsSkip) {
            this.md5 = data.getString("md5");
        }
        this.endpoints = endpoints;
        return true;
    }

    @Override
    public Endpoints get() {
        return this.endpoints;
    }

    private boolean check(String endpoint) {
        boolean success;
        if (this.okHttpClient == null) {
            return true;
        }
        String url = this.detectPath != null ? endpoint + this.detectPath : endpoint;
        Request request = new Request.Builder().get().url(url).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            String string = response.body().string();
            boolean bl = success = response.code() == 200;
            if (logger.isDebugEnabled()) {
                logger.debug("check, endpoint = {}, path = {}, code = {}, response = {}", new Object[]{endpoint, this.detectPath, response.code(), string});
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("check error, endpoint = {}, path = {}", new Object[]{endpoint, this.detectPath, e});
            }
            success = false;
        }
        return success;
    }
}

