/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core.endpoint;

import com.netease.nim.server.sdk.core.endpoint.ExecuteContext;
import com.netease.nim.server.sdk.core.endpoint.RetryPolicy;
import com.netease.nim.server.sdk.core.exception.HttpCodeException;
import com.netease.nim.server.sdk.core.utils.ExceptionUtils;

public class DefaultRetryPolicy
implements RetryPolicy {
    private final int maxRetry;
    private final boolean retryOn502;

    public DefaultRetryPolicy(int maxRetry, boolean retryOn502) {
        this.maxRetry = maxRetry;
        this.retryOn502 = retryOn502;
    }

    @Override
    public int maxRetry() {
        return this.maxRetry;
    }

    @Override
    public RetryPolicy.RetryAction onError(ExecuteContext retryContext, int retry, Throwable error) {
        if (error instanceof HttpCodeException && ((HttpCodeException)error).getCode() == 502 && this.retryOn502) {
            return RetryPolicy.RetryAction.RETRY_NEXT;
        }
        if (ExceptionUtils.isConnectError(error)) {
            return RetryPolicy.RetryAction.RETRY_NEXT;
        }
        return RetryPolicy.RetryAction.NO_RETRY;
    }
}

