/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.server.sdk.core;

import com.netease.nim.server.sdk.core.BizName;
import com.netease.nim.server.sdk.core.EndpointConfig;
import com.netease.nim.server.sdk.core.HttpClient;
import com.netease.nim.server.sdk.core.YunxinHttpClientConfig;
import com.netease.nim.server.sdk.core.endpoint.EndpointSelector;
import com.netease.nim.server.sdk.core.endpoint.ExecuteContext;
import com.netease.nim.server.sdk.core.endpoint.RequestResult;
import com.netease.nim.server.sdk.core.endpoint.RetryPolicy;
import com.netease.nim.server.sdk.core.exception.HttpCodeException;
import com.netease.nim.server.sdk.core.exception.YunxinSdkException;
import com.netease.nim.server.sdk.core.http.ContextType;
import com.netease.nim.server.sdk.core.http.HttpMethod;
import com.netease.nim.server.sdk.core.http.HttpResponse;
import com.netease.nim.server.sdk.core.http.ParamBuilder;
import com.netease.nim.server.sdk.core.metrics.MetricsConfig;
import com.netease.nim.server.sdk.core.metrics.Stats;
import com.netease.nim.server.sdk.core.metrics.YunxinApiSdkMetricsCollector;
import com.netease.nim.server.sdk.core.trace.ApiVersion;
import com.netease.nim.server.sdk.core.trace.TimeoutSetter;
import com.netease.nim.server.sdk.core.trace.TraceIdUtils;
import com.netease.nim.server.sdk.core.trace.YunxinTraceId;
import com.netease.nim.server.sdk.core.utils.CheckSumBuilder;
import com.netease.nim.server.sdk.core.utils.ExceptionUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunxinHttpClient
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(YunxinHttpClient.class);
    private static final String APPKEY = "AppKey";
    private static final String NONCE = "Nonce";
    private static final String CURTIME = "CurTime";
    private static final String CHECKSUM = "CheckSum";
    private static final String X_CUSTOM_TRACE_ID = "X-custom-traceid";
    private static final String REQUEST_ID = "RequestId";
    private final BizName bizName;
    private final String appkey;
    private final String appsecret;
    private final OkHttpClient okHttpClient;
    private final RetryPolicy retryPolicy;
    private final EndpointSelector endpointSelector;
    private YunxinApiSdkMetricsCollector metricsCollector;
    private boolean running = true;

    public YunxinHttpClient(BizName bizName, String appkey, String appsecret, EndpointConfig endpointConfig, YunxinHttpClientConfig httpClientConfig, MetricsConfig metricsConfig) {
        this.bizName = bizName;
        this.appkey = appkey;
        this.appsecret = appsecret;
        this.retryPolicy = endpointConfig.getRetryPolicy();
        this.endpointSelector = endpointConfig.getEndpointSelector();
        if (metricsConfig.isEnable()) {
            this.metricsCollector = new YunxinApiSdkMetricsCollector(bizName, metricsConfig.getCollectIntervalSeconds(), metricsConfig.getMetricsCallback());
        }
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(httpClientConfig.getMaxRequests());
        dispatcher.setMaxRequestsPerHost(httpClientConfig.getMaxRequestsPerHost());
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(httpClientConfig.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS).readTimeout(httpClientConfig.getReadTimeoutMillis(), TimeUnit.MILLISECONDS).writeTimeout(httpClientConfig.getWriteTimeoutMillis(), TimeUnit.MILLISECONDS).dispatcher(dispatcher).connectionPool(new ConnectionPool(httpClientConfig.getMaxIdleConnections(), (long)httpClientConfig.getKeepAliveSeconds(), TimeUnit.SECONDS));
        if (httpClientConfig.getProxy() != null) {
            builder.proxy(httpClientConfig.getProxy());
        }
        if (httpClientConfig.getProxySelector() != null) {
            builder.proxySelector(httpClientConfig.getProxySelector());
        }
        this.okHttpClient = builder.build();
        this.endpointSelector.init(this.okHttpClient);
    }

    /*
     * Loose catch block
     */
    @Override
    public HttpResponse execute(HttpMethod method, ContextType contextType, ApiVersion apiVersion, String uri, String path, Map<String, String> queryString, String data) throws YunxinSdkException {
        if (!this.running) {
            throw new IllegalStateException("yunxin http client has bean shutdown.");
        }
        String traceId = YunxinTraceId.get();
        if (traceId == null) {
            traceId = TraceIdUtils.gen();
        }
        try {
            String url;
            String endpoint = this.endpointSelector.selectEndpoint(null);
            ExecuteContext executeContext = new ExecuteContext(this.bizName, endpoint, method, contextType, apiVersion, uri, path, queryString, data, traceId);
            if (queryString == null || queryString.isEmpty()) {
                url = path;
            } else {
                ParamBuilder query = new ParamBuilder();
                for (Map.Entry<String, String> entry : queryString.entrySet()) {
                    query.addParam(entry.getKey(), entry.getValue());
                }
                url = path + "?" + query.build();
            }
            YunxinSdkException exception = null;
            int maxRetry = this.retryPolicy.maxRetry();
            if (maxRetry <= 0) {
                maxRetry = 0;
            }
            if (maxRetry > 128) {
                maxRetry = 128;
            }
            Long timeoutMillis = TimeoutSetter.getAndClear();
            OkHttpClient client = this.client(timeoutMillis);
            int i = 0;
            while (i <= maxRetry) {
                HttpResponse httpResponse;
                Throwable throwable;
                Response response;
                long startTime;
                block39: {
                    block40: {
                        Request.Builder builder = new Request.Builder();
                        if (method == HttpMethod.GET) {
                            builder.get();
                        } else {
                            builder.method(method.name(), RequestBody.create((MediaType)MediaType.parse((String)contextType.getValue()), (String)(data == null ? "" : data)));
                        }
                        builder.url(endpoint + url);
                        this.addHeaders(builder, apiVersion, traceId);
                        Request request = builder.build();
                        startTime = System.currentTimeMillis();
                        if (logger.isDebugEnabled()) {
                            logger.debug("execute, bizName = {}, endpoint = {}, method = {}, contextType = {}, apiVersion= {}, uri = {}, path = {}, traceId = {}, queryString = {}, data = {}", new Object[]{this.bizName, endpoint, method, contextType, apiVersion, uri, path, traceId, queryString, data});
                        }
                        response = client.newCall(request).execute();
                        throwable = null;
                        int code = response.code();
                        String string = response.body().string();
                        if (this.bizName.isHttpCodeAlways200() && code != 200) {
                            throw new HttpCodeException(this.bizName, endpoint, code, string);
                        }
                        this.endpointSelector.update(endpoint, RequestResult.SUCCESS);
                        if (this.metricsCollector != null) {
                            this.metricsCollector.collect(endpoint, method, contextType, apiVersion, uri, "success", System.currentTimeMillis() - startTime);
                        }
                        httpResponse = new HttpResponse(endpoint, code, string, traceId);
                        if (response == null) break block39;
                        if (throwable == null) break block40;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block39;
                    }
                    response.close();
                }
                return httpResponse;
                catch (Throwable code) {
                    try {
                        try {
                            throwable = code;
                            throw code;
                        }
                        catch (Throwable throwable3) {
                            if (response != null) {
                                if (throwable != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    response.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        RequestResult requestResult;
                        String result;
                        if (e instanceof HttpCodeException) {
                            int code2 = ((HttpCodeException)e).getCode();
                            result = "http_code_" + code2;
                            requestResult = code2 == 502 ? RequestResult.HTTP_CODE_502 : (code2 == 500 ? RequestResult.HTTP_CODE_500 : (code2 == 400 ? RequestResult.HTTP_CODE_400 : RequestResult.HTTP_CODE_NOT_200));
                        } else {
                            result = e.toString();
                            boolean connectError = ExceptionUtils.isConnectError(e);
                            requestResult = connectError ? RequestResult.CONNECT_TIMEOUT : (ExceptionUtils.isTimeoutError(e) ? RequestResult.READ_WRITE_TIMEOUT : RequestResult.OTHER_ERRORS);
                        }
                        this.endpointSelector.update(endpoint, requestResult);
                        if (this.metricsCollector != null) {
                            this.metricsCollector.collect(endpoint, method, contextType, apiVersion, uri, result, System.currentTimeMillis() - startTime);
                        }
                        exception = new YunxinSdkException(executeContext, e);
                        RetryPolicy.RetryAction retryAction = this.retryPolicy.onError(executeContext, i, e);
                        if (!retryAction.isRetry()) {
                            throw exception;
                        }
                        long interval = this.retryPolicy.retryInterval(executeContext, i);
                        if (interval > 0L) {
                            try {
                                TimeUnit.MILLISECONDS.sleep(interval);
                            }
                            catch (InterruptedException ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                        if (retryAction.isNextEndpoint()) {
                            endpoint = this.endpointSelector.selectEndpoint(endpoint);
                        }
                        ++i;
                    }
                }
            }
            throw exception;
        }
        finally {
            YunxinTraceId.clear();
        }
    }

    private OkHttpClient client(Long timeoutMillis) {
        if (timeoutMillis == null) {
            return this.okHttpClient;
        }
        return this.okHttpClient.newBuilder().connectTimeout(timeoutMillis.longValue(), TimeUnit.MILLISECONDS).readTimeout(timeoutMillis.longValue(), TimeUnit.MILLISECONDS).writeTimeout(timeoutMillis.longValue(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    public Stats getStats() {
        if (!this.running) {
            throw new IllegalStateException("yunxin http client has bean shutdown.");
        }
        if (this.metricsCollector == null) {
            return null;
        }
        return this.metricsCollector.getStats();
    }

    @Override
    public void shutdown() {
        if (this.metricsCollector != null) {
            this.metricsCollector.shutdown();
        }
        if (this.endpointSelector != null) {
            this.endpointSelector.shutdown();
        }
        this.running = false;
    }

    private void addHeaders(Request.Builder builder, ApiVersion apiVersion, String traceId) {
        String curTime = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        builder.addHeader(APPKEY, this.appkey);
        builder.addHeader(CURTIME, curTime);
        builder.addHeader(NONCE, nonce);
        builder.addHeader(CHECKSUM, CheckSumBuilder.getCheckSum(this.appsecret, nonce, curTime));
        if (this.bizName == BizName.IM) {
            if (apiVersion == ApiVersion.V1) {
                builder.addHeader(REQUEST_ID, traceId);
            } else if (apiVersion == ApiVersion.V2) {
                builder.addHeader(X_CUSTOM_TRACE_ID, traceId);
            }
        } else {
            builder.addHeader(X_CUSTOM_TRACE_ID, traceId);
        }
        builder.addHeader("User-Agent", "yunxin-server-sdk/1.1.2");
    }
}

