/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.io.resource;

import com.mzlion.core.io.resource.AbstractResourceDescriptor;
import com.mzlion.core.lang.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

class FileSystemResourceDescriptor
extends AbstractResourceDescriptor {
    private final File file;
    private final String path;

    public FileSystemResourceDescriptor(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        this.file = file;
        this.path = file.getPath();
    }

    public FileSystemResourceDescriptor(String path) {
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        this.path = path;
        this.file = new File(path);
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public URL getURL() throws IOException {
        return this.getURI().toURL();
    }

    @Override
    public URI getURI() throws IOException {
        return this.file.toURI();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public String getDescription() {
        return String.format("file [%s]", this.file.getAbsolutePath());
    }
}

