/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.http;

import com.mzlion.core.exceptions.GenericException;
import com.mzlion.core.http.ContentType;
import com.mzlion.core.json.gson.JsonUtil;
import com.mzlion.core.lang.Assert;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;

public class ResponseMessageUtils {
    public static void printWithTextPlan(String data, HttpServletResponse response) {
        ResponseMessageUtils._print(data, response, ContentType.TEXT_PLAIN);
    }

    public static void printWithTextPlan(String data, HttpServletResponse response, Charset charset) {
        Assert.notNull(charset, "The parameter[charset] is null.");
        ResponseMessageUtils._print(data, response, ContentType.create("text/plain", charset));
    }

    public static void printWithTextPlan(Object data, HttpServletResponse response) {
        ResponseMessageUtils.printWithTextPlan(JsonUtil.toJson(data), response);
    }

    public static void printWithApplicationJson(String data, HttpServletResponse response, Charset charset) {
        ResponseMessageUtils._print(data, response, ContentType.create("application/json", charset));
    }

    public static void printWithApplicationJson(String data, HttpServletResponse response) {
        ResponseMessageUtils._print(data, response, ContentType.APPLICATION_JSON);
    }

    public static void printWithApplicationJson(Object data, HttpServletResponse response) {
        ResponseMessageUtils._print(JsonUtil.toJson(data), response, ContentType.APPLICATION_JSON);
    }

    public static void printWithHtml(String html, HttpServletResponse response) {
        ResponseMessageUtils._print(html, response, ContentType.TEXT_HTML);
    }

    public static void printWithHtml(String html, HttpServletResponse response, Charset charset) {
        ResponseMessageUtils._print(html, response, ContentType.create("text/html", charset));
    }

    public static void printWithCss(String css, HttpServletResponse response) {
        ResponseMessageUtils.printWithCss(css, response, Charset.forName("UTF-8"));
    }

    public static void printWithCss(String css, HttpServletResponse response, Charset charset) {
        ResponseMessageUtils._print(css, response, ContentType.create("text/css", charset));
    }

    public static void printWithJavascript(String js, HttpServletResponse response) {
        ResponseMessageUtils.printWithJavascript(js, response, Charset.forName("UTF-8"));
    }

    public static void printWithJavascript(String js, HttpServletResponse response, Charset charset) {
        ResponseMessageUtils._print(js, response, ContentType.create("application/javascript", charset));
    }

    public static void printWithXml(String xml, HttpServletResponse response) {
        ResponseMessageUtils._print(xml, response, ContentType.TEXT_XML);
    }

    public static void printWithXml(String xml, HttpServletResponse response, Charset charset) {
        ResponseMessageUtils._print(xml, response, ContentType.create("text/xml", charset));
    }

    private static void _print(String data, HttpServletResponse response, ContentType contentType) {
        Assert.notNull(response, "The parameter[response] is null.");
        if (data == null) {
            data = "";
        }
        try {
            response.setContentType(contentType.toString());
            response.getWriter().write(data);
        }
        catch (IOException e) {
            throw new GenericException(e);
        }
    }
}

