/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.http;

import com.mzlion.core.io.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class InputStreamRequestBody
extends RequestBody {
    private final byte[] content;
    private final int byteCount;
    private final MediaType mediaType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStreamRequestBody(InputStream content, MediaType mediaType) {
        this.mediaType = mediaType;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)content, (OutputStream)baos);
            this.content = baos.toByteArray();
            this.byteCount = this.content.length;
        }
        finally {
            IOUtils.closeQuietly((Closeable)content);
        }
    }

    public long contentLength() throws IOException {
        return this.byteCount;
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        sink.write(this.content, 0, this.byteCount);
    }
}

