/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class FileRequestBody
extends RequestBody {
    private final File file;
    private final MediaType mediaType;

    public FileRequestBody(File file, MediaType mediaType) {
        this.file = file;
        this.mediaType = mediaType;
    }

    public long contentLength() throws IOException {
        return this.file.length();
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((File)this.file);
            sink.writeAll(source);
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }
}

