/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.http;

import com.mzlion.core.lang.Assert;
import com.mzlion.easyokhttp.http.Header;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class BasicHeader
implements Header,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6025489654253774764L;
    private final String name;
    private final String value;

    public BasicHeader(String name, String value) {
        Assert.hasLength((String)name, (String)"name may not be null.");
        Assert.notNull((Object)value, (String)"Value may not be null.");
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        int length = this.name.length() + 2;
        if (this.value != null) {
            length += this.value.length();
        }
        StringBuilder result = new StringBuilder(length);
        result.append(this.name).append(" :");
        if (this.value != null) {
            result.append(this.value);
        }
        return result.toString();
    }

    public static StandardBuilder standard() {
        return StandardBuilder.create();
    }

    public static class StandardBuilder {
        private final List<String> headerFields = new ArrayList<String>();
        private final List<String> headerValues = new ArrayList<String>();

        StandardBuilder() {
        }

        public static StandardBuilder create() {
            return new StandardBuilder();
        }

        public StandardBuilder accept(String value) {
            this.tryDo("Accept", value);
            return this;
        }

        public StandardBuilder acceptCharset(String value) {
            this.tryDo("Accept-Charset", value);
            return this;
        }

        public StandardBuilder acceptEncoding(String value) {
            this.tryDo("Accept-Encoding", value);
            return this;
        }

        public StandardBuilder acceptLanguage(String value) {
            this.tryDo("Accept-Language", value);
            return this;
        }

        public StandardBuilder acceptRanges(String value) {
            this.tryDo("Accept-Ranges", value);
            return this;
        }

        public StandardBuilder age(String value) {
            this.tryDo("Age", value);
            return this;
        }

        public StandardBuilder allow(String value) {
            this.tryDo("Allow", value);
            return this;
        }

        public StandardBuilder cacheControl(String value) {
            this.tryDo("Cache-Control", value);
            return this;
        }

        public StandardBuilder connection(String value) {
            this.tryDo("Connection", value);
            return this;
        }

        public StandardBuilder contentEncoding(String value) {
            this.tryDo("Content-Encoding", value);
            return this;
        }

        public StandardBuilder contentLanguage(String value) {
            this.tryDo("Content-Language", value);
            return this;
        }

        public StandardBuilder contentLength(String value) {
            this.tryDo("Content-Length", value);
            return this;
        }

        public StandardBuilder contentLocation(String value) {
            this.tryDo("Content-Location", value);
            return this;
        }

        public StandardBuilder contentMD5(String value) {
            this.tryDo("Content-MD5", value);
            return this;
        }

        public StandardBuilder contentRange(String value) {
            this.tryDo("Content-Range", value);
            return this;
        }

        public StandardBuilder contentType(String value) {
            this.tryDo("Content-Type", value);
            return this;
        }

        public StandardBuilder contentDisposition(String value) {
            this.tryDo("Content-Disposition", value);
            return this;
        }

        public StandardBuilder userAgent(String value) {
            this.tryDo("User-Agent", value);
            return this;
        }

        public List<Header> build() {
            LinkedList<Header> headerList = new LinkedList<Header>();
            int size = this.headerFields.size();
            for (int i = 0; i < size; ++i) {
                BasicHeader header = new BasicHeader(this.headerFields.get(i), this.headerValues.get(i));
                headerList.add(header);
            }
            return headerList;
        }

        private void tryDo(String name, String value) {
            int index = this.headerFields.indexOf(name);
            if (index == -1) {
                this.headerFields.add(name);
                this.headerValues.set(this.headerFields.size() - 1, value);
            } else {
                this.headerValues.set(index, value);
            }
        }
    }
}

