/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.boot;

import com.mybatisflex.core.datasource.DataSourceBuilder;
import com.mybatisflex.core.datasource.DataSourceDecipher;
import com.mybatisflex.core.datasource.DataSourceManager;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.util.MapUtil;
import com.mybatisflex.spring.boot.ConditionalOnMybatisFlexDatasource;
import com.mybatisflex.spring.boot.MybatisFlexProperties;
import com.mybatisflex.spring.datasource.DataSourceAdvice;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.xa.DataSourceProxyXA;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@ConditionalOnMybatisFlexDatasource
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MybatisFlexProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class}, name={"com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure", "com.alibaba.druid.spring.boot3.autoconfigure.DruidDataSourceAutoConfigure"})
public class MultiDataSourceAutoConfiguration {
    private final String master;
    private final Map<String, Map<String, String>> dataSourceProperties;
    private final MybatisFlexProperties.SeataConfig seataConfig;
    protected final DataSourceDecipher dataSourceDecipher;

    public MultiDataSourceAutoConfiguration(MybatisFlexProperties properties, ObjectProvider<DataSourceDecipher> dataSourceDecipherProvider) {
        this.dataSourceProperties = properties.getDatasource();
        this.dataSourceDecipher = (DataSourceDecipher)dataSourceDecipherProvider.getIfAvailable();
        this.seataConfig = properties.getSeataConfig();
        this.master = properties.getDefaultDatasourceKey();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource() {
        FlexDataSource flexDataSource = null;
        if (this.dataSourceProperties != null && !this.dataSourceProperties.isEmpty()) {
            if (this.dataSourceDecipher != null) {
                DataSourceManager.setDecipher((DataSourceDecipher)this.dataSourceDecipher);
            }
            if (this.master != null) {
                Map<String, String> map = this.dataSourceProperties.remove(this.master);
                if (map != null) {
                    flexDataSource = this.addDataSource(MapUtil.entry((Object)this.master, map), flexDataSource);
                } else {
                    throw FlexExceptions.wrap((String)"\u6ca1\u6709\u627e\u5230\u9ed8\u8ba4\u6570\u636e\u6e90 \"%s\" \u5bf9\u5e94\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u591a\u6570\u636e\u6e90\u914d\u7f6e\u3002", (Object[])new Object[]{this.master});
                }
            }
            for (Map.Entry<String, Map<String, String>> entry : this.dataSourceProperties.entrySet()) {
                flexDataSource = this.addDataSource(entry, flexDataSource);
            }
        }
        return flexDataSource;
    }

    private FlexDataSource addDataSource(Map.Entry<String, Map<String, String>> entry, FlexDataSource flexDataSource) {
        DataSource dataSource = new DataSourceBuilder(entry.getValue()).build();
        DataSourceManager.decryptDataSource((DataSource)dataSource);
        if (this.seataConfig != null && this.seataConfig.isEnable()) {
            dataSource = this.seataConfig.getSeataMode() == MybatisFlexProperties.SeataMode.XA ? new DataSourceProxyXA(dataSource) : new DataSourceProxy(dataSource);
        }
        if (flexDataSource == null) {
            flexDataSource = new FlexDataSource(entry.getKey(), dataSource, false);
        } else {
            flexDataSource.addDataSource(entry.getKey(), dataSource, false);
        }
        return flexDataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    @Role(value=2)
    public DataSourceAdvice dataSourceAdvice() {
        return new DataSourceAdvice();
    }
}

